/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.enums;

public enum MessageType {
    CONNECT(1),
    SUBSCRIBE(2),
    UNSUBSCRIBE(3),
    UP_STREAM(4),
    DOWN_STREAM(5),
    DISCONNECT(6),
    HTTP_API(7);

    private static final MessageType[] VALUES;
    private final int value;

    private MessageType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MessageType valueOf(int type) {
        if (type <= 0 || type >= VALUES.length) {
            throw new IllegalArgumentException("unknown message type: " + type);
        }
        return VALUES[type];
    }

    static {
        MessageType[] values = MessageType.values();
        VALUES = new MessageType[values.length + 1];
        for (MessageType mqttMessageType : values) {
            int value = mqttMessageType.value;
            if (VALUES[value] != null) {
                throw new AssertionError((Object)("value already in use: " + value));
            }
            MessageType.VALUES[value] = mqttMessageType;
        }
    }
}

