/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.auto.aot;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.dreamlu.mica.auto.annotation.AotBeanFactoryInitialization;
import net.dreamlu.mica.auto.annotation.AotBeanRegistration;
import net.dreamlu.mica.auto.annotation.AotRuntimeHintsRegistrar;
import net.dreamlu.mica.auto.aot.FactoriesFiles;
import net.dreamlu.mica.auto.common.AbstractMicaProcessor;
import net.dreamlu.mica.auto.common.AotAutoType;
import net.dreamlu.mica.auto.common.MultiSetMap;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

@SupportedOptions(value={"debug"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.AGGREGATING)
public class AotFactoriesProcessor
extends AbstractMicaProcessor {
    private static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring/aot.factories";
    private final MultiSetMap<String, String> factories = new MultiSetMap();
    private Elements elementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Stream.of(AotRuntimeHintsRegistrar.class.getName(), AotBeanRegistration.class.getName(), AotBeanFactoryInitialization.class.getName()).collect(Collectors.toSet());
    }

    @Override
    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateFactoriesFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return false;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log(annotations.toString());
        Set<? extends Element> elementSet = roundEnv.getRootElements();
        this.log("All Element set: " + elementSet.toString());
        Set typeElementSet = elementSet.stream().filter(x$0 -> this.isClassOrInterface((Element)x$0)).filter(TypeElement.class::isInstance).map(TypeElement.class::cast).collect(Collectors.toSet());
        if (typeElementSet.isEmpty()) {
            this.log("Annotations elementSet is isEmpty");
            return;
        }
        for (TypeElement typeElement : typeElementSet) {
            for (AotAutoType autoType : AotAutoType.values()) {
                String annotation = autoType.getAnnotation();
                if (!this.isAnnotation(this.elementUtils, typeElement, annotation)) continue;
                this.log("Found @" + annotation + " Element: " + typeElement.toString());
                String factoryName = typeElement.getQualifiedName().toString();
                if (this.factories.containsVal(factoryName)) continue;
                this.log("\u8bfb\u53d6\u5230\u65b0\u914d\u7f6e aot.factories factoryName\uff1a" + factoryName);
                this.factories.put(autoType.getConfigureKey(), factoryName);
            }
        }
    }

    private void generateFactoriesFiles() {
        if (this.factories.isEmpty()) {
            return;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            MultiSetMap<String, String> existingFactories;
            FileObject existingFactoriesFile;
            MultiSetMap<String, String> allFactories = new MultiSetMap<String, String>();
            try {
                existingFactoriesFile = filer.getResource(StandardLocation.SOURCE_OUTPUT, "", FACTORIES_RESOURCE_LOCATION);
                this.log("Looking for existing aot.factories file at " + existingFactoriesFile.toUri());
                existingFactories = FactoriesFiles.readFactoriesFile(existingFactoriesFile, this.elementUtils);
                this.log("Existing aot.factories entries: " + existingFactories);
                allFactories.putAll(existingFactories);
            }
            catch (IOException e) {
                this.log("aot.factories resource file not found.");
            }
            try {
                existingFactoriesFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", FACTORIES_RESOURCE_LOCATION);
                this.log("Looking for existing aot.factories file at " + existingFactoriesFile.toUri());
                existingFactories = FactoriesFiles.readFactoriesFile(existingFactoriesFile, this.elementUtils);
                this.log("Existing aot.factories entries: " + existingFactories);
                allFactories.putAll(existingFactories);
            }
            catch (IOException e) {
                this.log("aot.factories resource file did not already exist.");
            }
            allFactories.putAll(this.factories);
            this.log("New aot.factories file contents: " + allFactories);
            FileObject factoriesFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", FACTORIES_RESOURCE_LOCATION, new Element[0]);
            try (OutputStream out = factoriesFile.openOutputStream();){
                FactoriesFiles.writeFactoriesFile(allFactories, out);
            }
        }
        catch (IOException e) {
            this.fatalError(e);
        }
    }
}

