/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.auto.factories;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.dreamlu.mica.auto.common.AbstractMicaProcessor;
import net.dreamlu.mica.auto.common.BootAutoType;
import net.dreamlu.mica.auto.common.MultiSetMap;
import net.dreamlu.mica.auto.factories.FactoriesFiles;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"debug"})
public class AutoFactoriesProcessor
extends AbstractMicaProcessor {
    private static final String FEIGN_CLIENT_ANNOTATION = "org.springframework.cloud.openfeign.FeignClient";
    private static final String FEIGN_AUTO_CONFIGURE_KEY = "net.dreamlu.mica.feign.MicaFeignAutoConfiguration";
    private static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring.factories";
    private static final String DEVTOOLS_RESOURCE_LOCATION = "META-INF/spring-devtools.properties";
    private MultiSetMap<String, String> factories = new MultiSetMap();
    private Elements elementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateFactoriesFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return false;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log(annotations.toString());
        Set<? extends Element> elementSet = roundEnv.getRootElements();
        this.log("All Element set: " + elementSet.toString());
        Set typeElementSet = elementSet.stream().filter(this::isClassOrInterface).filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e).collect(Collectors.toSet());
        if (typeElementSet.isEmpty()) {
            this.log("Annotations elementSet is isEmpty");
            return;
        }
        for (TypeElement typeElement : typeElementSet) {
            if (this.isAnnotation(this.elementUtils, typeElement, FEIGN_CLIENT_ANNOTATION)) {
                this.log("Found @FeignClient Element: " + typeElement.toString());
                ElementKind elementKind = typeElement.getKind();
                if (ElementKind.INTERFACE != elementKind) {
                    this.fatalError("@FeignClient Element " + typeElement.toString() + " \u4e0d\u662f\u63a5\u53e3\u3002");
                    continue;
                }
                String factoryName = typeElement.getQualifiedName().toString();
                if (this.factories.containsVal(factoryName)) continue;
                this.log("\u8bfb\u53d6\u5230\u65b0\u914d\u7f6e spring.factories factoryName\uff1a" + factoryName);
                this.factories.put(FEIGN_AUTO_CONFIGURE_KEY, factoryName);
                continue;
            }
            for (BootAutoType autoType : BootAutoType.values()) {
                String annotation = autoType.getAnnotation();
                if (!this.isAnnotation(this.elementUtils, typeElement, annotation)) continue;
                this.log("Found @" + annotation + " Element: " + typeElement.toString());
                String factoryName = typeElement.getQualifiedName().toString();
                if (this.factories.containsVal(factoryName)) continue;
                this.log("\u8bfb\u53d6\u5230\u65b0\u914d\u7f6e spring.factories factoryName\uff1a" + factoryName);
                this.factories.put(autoType.getConfigureKey(), factoryName);
            }
        }
    }

    private void generateFactoriesFiles() {
        if (this.factories.isEmpty()) {
            return;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            FileObject factoriesFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", FACTORIES_RESOURCE_LOCATION, new Element[0]);
            FactoriesFiles.writeFactoriesFile(this.factories, factoriesFile.openOutputStream());
            String classesPath = factoriesFile.toUri().toString().split("classes")[0];
            Path projectPath = Paths.get(new URI(classesPath)).getParent();
            String projectName = projectPath.getFileName().toString();
            FileObject devToolsFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", DEVTOOLS_RESOURCE_LOCATION, new Element[0]);
            FactoriesFiles.writeDevToolsFile(projectName, devToolsFile.openOutputStream());
        }
        catch (IOException | URISyntaxException e) {
            this.fatalError(e);
        }
    }

    private boolean isClassOrInterface(Element e) {
        ElementKind kind = e.getKind();
        return kind == ElementKind.CLASS || kind == ElementKind.INTERFACE;
    }

    private boolean isAnnotation(Elements elementUtils, Element e, String annotationFullName) {
        List<? extends AnnotationMirror> annotationList = elementUtils.getAllAnnotationMirrors(e);
        for (AnnotationMirror annotationMirror : annotationList) {
            if (this.isAnnotation(annotationFullName, annotationMirror)) {
                return true;
            }
            Element element = annotationMirror.getAnnotationType().asElement();
            if (element.toString().startsWith("java.lang") || !this.isAnnotation(elementUtils, element, annotationFullName)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnnotation(String annotationFullName, AnnotationMirror annotation) {
        return annotationFullName.equals(annotation.getAnnotationType().toString());
    }
}

