/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.body;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.dongliu.commons.Objects2;
import net.dongliu.commons.annotation.Nullable;
import net.dongliu.commons.io.InputStreams;
import net.dongliu.requests.body.ContentTypes;
import net.dongliu.requests.body.InputStreamSupplier;

public class Part<T>
implements Serializable {
    private static final long serialVersionUID = -8628605676399143491L;
    private final String name;
    private final @Nullable String fileName;
    private final T body;
    private final @Nullable String contentType;
    private final @Nullable Charset charset;
    private final PartWriter<T> partWriter;

    private Part(String name, @Nullable String fileName, T body, @Nullable String contentType, @Nullable Charset charset, PartWriter<T> partWriter) {
        this.name = Objects.requireNonNull(name);
        this.fileName = fileName;
        this.body = Objects.requireNonNull(body);
        this.contentType = contentType;
        this.charset = charset;
        this.partWriter = partWriter;
    }

    public Part<T> contentType(String contentType) {
        Objects.requireNonNull(contentType);
        return new Part<T>(this.name, this.fileName, this.body, contentType, this.charset, this.partWriter);
    }

    public Part<T> charset(Charset charset) {
        Objects.requireNonNull(charset);
        return new Part<T>(this.name, this.fileName, this.body, this.contentType, charset, this.partWriter);
    }

    public static Part<File> file(String name, File file) {
        return Part.file(name, file.getName(), file);
    }

    public static Part<File> file(String name, String fileName, File file) {
        return new Part<File>(name, fileName, file, ContentTypes.probeContentType(file), null, (body, out, charset) -> {
            try (FileInputStream in = new FileInputStream((File)body);){
                InputStreams.transferTo((InputStream)in, (OutputStream)out);
            }
        });
    }

    @Deprecated
    public static Part<InputStream> file(String name, String fileName, InputStream in) {
        return new Part<InputStream>(name, fileName, in, "application/octet-stream", null, (body, out, charset) -> {
            try (InputStream bin = body;){
                InputStreams.transferTo((InputStream)bin, (OutputStream)out);
            }
        });
    }

    public static Part<InputStreamSupplier> file(String name, String fileName, InputStreamSupplier supplier) {
        return new Part<InputStreamSupplier>(name, fileName, supplier, "application/octet-stream", null, (body, out, charset) -> {
            try (InputStream bin = body.get();){
                InputStreams.transferTo((InputStream)bin, (OutputStream)out);
            }
        });
    }

    public static Part<byte[]> file(String name, String fileName, byte[] bytes) {
        return new Part<byte[]>(name, fileName, bytes, "application/octet-stream", null, (body, out, charset) -> out.write((byte[])body));
    }

    public static Part<String> text(String name, String value) {
        return new Part<String>(name, null, value, null, null, (body, out, charset) -> {
            OutputStreamWriter writer = new OutputStreamWriter(out, (Charset)Objects2.elvis((Object)charset, (Object)StandardCharsets.ISO_8859_1));
            writer.write((String)body);
            writer.flush();
        });
    }

    @Deprecated
    public static Part<String> param(String name, String value) {
        return Part.text(name, value);
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    @Deprecated
    public @Nullable String getFileName() {
        return this.fileName;
    }

    @Deprecated
    public T getBody() {
        return this.body;
    }

    @Deprecated
    public @Nullable String getContentType() {
        return this.contentType;
    }

    @Deprecated
    public @Nullable Charset getCharset() {
        return this.charset;
    }

    public String name() {
        return this.name;
    }

    public @Nullable String fileName() {
        return this.fileName;
    }

    public T body() {
        return this.body;
    }

    public @Nullable String contentType() {
        return this.contentType;
    }

    public @Nullable Charset charset() {
        return this.charset;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.partWriter.writeTo(this.body, out, this.charset);
    }

    private static interface PartWriter<T> {
        public void writeTo(T var1, OutputStream var2, @Nullable Charset var3) throws IOException;
    }
}

