/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.dongliu.commons.Lazy;
import net.dongliu.commons.annotation.InternalUseOnly;
import net.dongliu.commons.annotation.Nullable;
import net.dongliu.commons.io.Closeables;
import net.dongliu.commons.io.InputStreams;
import net.dongliu.commons.io.Readers;
import net.dongliu.requests.AbstractResponse;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.Headers;
import net.dongliu.requests.Response;
import net.dongliu.requests.ResponseHandler;
import net.dongliu.requests.exception.RequestsException;
import net.dongliu.requests.json.JsonLookup;
import net.dongliu.requests.json.TypeInfer;

public class RawResponse
extends AbstractResponse
implements AutoCloseable {
    private final String method;
    private final String statusLine;
    private final InputStream body;
    private final HttpURLConnection conn;
    private final @Nullable Charset charset;
    private final boolean decompress;
    private Lazy<InputStream> decompressedBody = Lazy.of(this::decompressBody);

    @InternalUseOnly
    public RawResponse(String method, String url, int statusCode, String statusLine, List<Cookie> cookies, Headers headers, InputStream input, HttpURLConnection conn) {
        super(url, statusCode, cookies, headers);
        this.method = method;
        this.statusLine = statusLine;
        this.body = input;
        this.conn = conn;
        this.charset = null;
        this.decompress = true;
    }

    private RawResponse(String method, String url, int statusCode, String statusLine, List<Cookie> cookies, Headers headers, InputStream input, HttpURLConnection conn, Charset charset, boolean decompress) {
        super(url, statusCode, cookies, headers);
        this.method = method;
        this.statusLine = statusLine;
        this.body = input;
        this.conn = conn;
        this.charset = charset;
        this.decompress = decompress;
    }

    @Override
    public void close() {
        Closeables.closeQuietly((AutoCloseable)this.body);
        this.conn.disconnect();
    }

    @Deprecated
    public RawResponse withCharset(Charset charset) {
        return this.charset(charset);
    }

    public RawResponse charset(Charset charset) {
        return new RawResponse(this.method, this.url, this.statusCode, this.statusLine, this.cookies, this.headers, this.body, this.conn, charset, this.decompress);
    }

    public RawResponse charset(String charset) {
        return this.charset(Charset.forName(Objects.requireNonNull(charset)));
    }

    public RawResponse decompress(boolean decompress) {
        return new RawResponse(this.method, this.url, this.statusCode, this.statusLine, this.cookies, this.headers, this.body, this.conn, this.charset, decompress);
    }

    /*
     * Exception decompiling
     */
    public String readToText() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Response<String> toTextResponse() {
        return new Response<String>(this.url, this.statusCode, this.cookies, this.headers, this.readToText());
    }

    public byte[] readToBytes() {
        try {
            byte[] byArray;
            block11: {
                InputStream in = this.body();
                try {
                    byArray = InputStreams.readAll((InputStream)in);
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RequestsException(e);
                    }
                }
                in.close();
            }
            return byArray;
        }
        finally {
            this.close();
        }
    }

    public <T> Response<T> toResponse(ResponseHandler<T> handler) {
        ResponseHandler.ResponseInfo responseInfo = new ResponseHandler.ResponseInfo(this.url, this.statusCode, this.headers, this.body());
        try {
            T result = handler.handle(responseInfo);
            Response<T> response = new Response<T>(this.url, this.statusCode, this.cookies, this.headers, result);
            return response;
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public Response<byte[]> toBytesResponse() {
        return new Response<byte[]>(this.url, this.statusCode, this.cookies, this.headers, this.readToBytes());
    }

    public <T> T readToJson(Type type) {
        try {
            Object t = JsonLookup.getInstance().lookup().unmarshal(this.body(), this.getCharset(), type);
            return t;
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public <T> T readToJson(TypeInfer<T> typeInfer) {
        return this.readToJson(typeInfer.getType());
    }

    public <T> T readToJson(Class<T> cls) {
        return this.readToJson((Type)cls);
    }

    public <T> Response<T> toJsonResponse(TypeInfer<T> typeInfer) {
        return new Response<T>(this.url, this.statusCode, this.cookies, this.headers, this.readToJson(typeInfer));
    }

    public <T> Response<T> toJsonResponse(Class<T> cls) {
        return new Response<T>(this.url, this.statusCode, this.cookies, this.headers, this.readToJson(cls));
    }

    public void writeToFile(File file) {
        try (FileOutputStream os = new FileOutputStream(file);){
            InputStreams.transferTo((InputStream)this.body(), (OutputStream)os);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeToFile(Path path) {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            InputStreams.transferTo((InputStream)this.body(), (OutputStream)os);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeToFile(String path) {
        try (FileOutputStream os = new FileOutputStream(path);){
            InputStreams.transferTo((InputStream)this.body(), (OutputStream)os);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public Response<File> toFileResponse(Path path) {
        File file = path.toFile();
        this.writeToFile(file);
        return new Response<File>(this.url, this.statusCode, this.cookies, this.headers, file);
    }

    public void writeTo(OutputStream out) {
        try {
            InputStreams.transferTo((InputStream)this.body(), (OutputStream)out);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeTo(Writer writer) {
        try (InputStream in = this.body();
             InputStreamReader reader = new InputStreamReader(in, this.getCharset());){
            Readers.transferTo((Reader)reader, (Writer)writer);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public void discardBody() {
        try (InputStream in = this.body;){
            InputStreams.discardAll((InputStream)in);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    @Deprecated
    public String getStatusLine() {
        return this.statusLine;
    }

    public String statusLine() {
        return this.statusLine;
    }

    @Deprecated
    public InputStream getInput() {
        return (InputStream)this.decompressedBody.get();
    }

    public InputStream body() {
        return (InputStream)this.decompressedBody.get();
    }

    private Charset getCharset() {
        if (this.charset != null) {
            return this.charset;
        }
        return this.headers.getCharset(StandardCharsets.UTF_8);
    }

    private InputStream decompressBody() {
        if (!this.decompress) {
            return this.body;
        }
        if (this.method.equals("HEAD") || this.statusCode >= 100 && this.statusCode < 200 || this.statusCode == 304 || this.statusCode == 204) {
            return this.body;
        }
        String contentEncoding = this.headers.getHeader("Content-Encoding");
        if (contentEncoding == null) {
            return this.body;
        }
        switch (contentEncoding) {
            case "gzip": {
                try {
                    return new GZIPInputStream(this.body);
                }
                catch (IOException e) {
                    Closeables.closeQuietly((AutoCloseable)this.body);
                    throw new RequestsException(e);
                }
            }
            case "deflate": {
                return new InflaterInputStream(this.body, new Inflater(true));
            }
        }
        return this.body;
    }
}

