/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.authentication;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class CompositeGrpcAuthenticationReader
implements GrpcAuthenticationReader {
    private final List<GrpcAuthenticationReader> authenticationReaders;

    public CompositeGrpcAuthenticationReader(List<GrpcAuthenticationReader> authenticationReaders) {
        this.authenticationReaders = new ArrayList<GrpcAuthenticationReader>((Collection)Objects.requireNonNull(authenticationReaders, "authenticationReaders"));
    }

    @Override
    public Authentication readAuthentication(ServerCall<?, ?> call, Metadata headers) throws AuthenticationException {
        for (GrpcAuthenticationReader authenticationReader : this.authenticationReaders) {
            Authentication authentication = authenticationReader.readAuthentication(call, headers);
            if (authentication == null) continue;
            return authentication;
        }
        return null;
    }
}

