/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class DiscoveryClientNameResolver
extends NameResolver {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClientNameResolver.class);
    private final String name;
    private final DiscoveryClient client;
    private final SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private ScheduledExecutorService timerService;
    @GuardedBy(value="this")
    private Executor executor;
    @GuardedBy(value="this")
    private ScheduledFuture<?> resolutionTask;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    @GuardedBy(value="this")
    private List<ServiceInstance> serviceInstanceList;
    private final Runnable resolutionRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameResolver.Listener savedListener;
            DiscoveryClientNameResolver discoveryClientNameResolver = DiscoveryClientNameResolver.this;
            synchronized (discoveryClientNameResolver) {
                if (DiscoveryClientNameResolver.this.resolutionTask != null) {
                    DiscoveryClientNameResolver.this.resolutionTask.cancel(false);
                    DiscoveryClientNameResolver.this.resolutionTask = null;
                }
                if (DiscoveryClientNameResolver.this.shutdown) {
                    return;
                }
                savedListener = DiscoveryClientNameResolver.this.listener;
                DiscoveryClientNameResolver.this.resolving = true;
            }
            try {
                List newServiceInstanceList;
                try {
                    newServiceInstanceList = DiscoveryClientNameResolver.this.client.getInstances(DiscoveryClientNameResolver.this.name);
                }
                catch (Exception e) {
                    savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)e));
                    DiscoveryClientNameResolver discoveryClientNameResolver2 = DiscoveryClientNameResolver.this;
                    synchronized (discoveryClientNameResolver2) {
                        DiscoveryClientNameResolver.this.resolving = false;
                    }
                    return;
                }
                if (!CollectionUtils.isEmpty((Collection)newServiceInstanceList)) {
                    if (!DiscoveryClientNameResolver.this.isNeedToUpdateServiceInstanceList(newServiceInstanceList)) {
                        return;
                    }
                    DiscoveryClientNameResolver.this.serviceInstanceList = newServiceInstanceList;
                    ArrayList equivalentAddressGroups = Lists.newArrayList();
                    for (ServiceInstance serviceInstance : DiscoveryClientNameResolver.this.serviceInstanceList) {
                        Map metadata = serviceInstance.getMetadata();
                        if (metadata.get("gRPC.port") != null) {
                            Integer port = Integer.valueOf((String)metadata.get("gRPC.port"));
                            log.info("Found gRPC server {} {}:{}", new Object[]{DiscoveryClientNameResolver.this.name, serviceInstance.getHost(), port});
                            EquivalentAddressGroup addressGroup = new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(serviceInstance.getHost(), (int)port), Attributes.EMPTY);
                            equivalentAddressGroups.add(addressGroup);
                            continue;
                        }
                        log.error("Can not found gRPC server {}", (Object)DiscoveryClientNameResolver.this.name);
                    }
                    savedListener.onAddresses((List)equivalentAddressGroups, Attributes.EMPTY);
                } else {
                    savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)new RuntimeException("UNAVAILABLE: NameResolver returned an empty list")));
                }
            }
            finally {
                DiscoveryClientNameResolver discoveryClientNameResolver3 = DiscoveryClientNameResolver.this;
                synchronized (discoveryClientNameResolver3) {
                    DiscoveryClientNameResolver.this.resolving = false;
                }
            }
        }
    };

    public DiscoveryClientNameResolver(String name, DiscoveryClient client, SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource, SharedResourceHolder.Resource<Executor> executorResource) {
        this.name = name;
        this.client = client;
        this.timerServiceResource = timerServiceResource;
        this.executorResource = executorResource;
        this.serviceInstanceList = Lists.newArrayList();
    }

    public final String getServiceAuthority() {
        return this.name;
    }

    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.timerService = (ScheduledExecutorService)SharedResourceHolder.get(this.timerServiceResource);
        this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    public final synchronized void refresh() {
        if (this.listener != null) {
            this.resolve();
        }
    }

    private boolean isNeedToUpdateServiceInstanceList(List<ServiceInstance> newServiceInstanceList) {
        if (this.serviceInstanceList.size() == newServiceInstanceList.size()) {
            for (ServiceInstance serviceInstance : this.serviceInstanceList) {
                boolean isSame = false;
                for (ServiceInstance newServiceInstance : newServiceInstanceList) {
                    if (!newServiceInstance.getHost().equals(serviceInstance.getHost()) || newServiceInstance.getPort() != serviceInstance.getPort()) continue;
                    isSame = true;
                    break;
                }
                if (isSame) continue;
                log.info("Ready to update {} server info group list", (Object)this.name);
                return true;
            }
        } else {
            log.info("Ready to update {} server info group list", (Object)this.name);
            return true;
        }
        return false;
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionRunnable);
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.resolutionTask != null) {
            this.resolutionTask.cancel(false);
        }
        if (this.timerService != null) {
            this.timerService = (ScheduledExecutorService)SharedResourceHolder.release(this.timerServiceResource, (Object)this.timerService);
        }
        if (this.executor != null) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
    }

    public String toString() {
        return "DiscoveryClientNameResolver [name=" + this.name + ", discoveryClient=" + this.client + "]";
    }
}

