/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.autoconfigure;

import com.google.common.collect.ImmutableList;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.util.List;
import net.devh.boot.grpc.client.autoconfigure.GrpcClientAutoConfiguration;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.nameresolver.CompositeNameResolverFactory;
import net.devh.boot.grpc.client.nameresolver.ConfigMappedNameResolverFactory;
import net.devh.boot.grpc.client.nameresolver.DiscoveryClientResolverFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnBean(value={DiscoveryClient.class})
@AutoConfigureBefore(value={GrpcClientAutoConfiguration.class})
public class GrpcDiscoveryClientAutoConfiguration {
    @ConditionalOnMissingBean
    @Lazy
    @Bean
    @Primary
    NameResolver.Factory grpcNameResolverProviderWithDiscovery(GrpcChannelsProperties channelProperties, DiscoveryClientResolverFactory discoveryClientResolverFactory) {
        ImmutableList factories = ImmutableList.builder().add((Object)discoveryClientResolverFactory).add((Object)NameResolverProvider.asFactory()).build();
        return new ConfigMappedNameResolverFactory(channelProperties, new CompositeNameResolverFactory("discovery", (List<NameResolver.Factory>)factories), DiscoveryClientResolverFactory.DISCOVERY_DEFAULT_URI_MAPPER);
    }

    @ConditionalOnMissingBean
    @Lazy
    @Bean
    DiscoveryClientResolverFactory grpcDiscoveryClientResolverFactory(DiscoveryClient client) {
        return new DiscoveryClientResolverFactory(client);
    }
}

