/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.management.JMException;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.HttpPart;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.ConnectionInformations;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.CounterRequestAggregation;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.HsErrPid;
import net.bull.javamelody.internal.model.JRobin;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.MBeans;
import net.bull.javamelody.internal.model.MavenArtifact;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.SessionInformations;
import net.bull.javamelody.internal.model.ThreadInformations;
import net.bull.javamelody.internal.model.TransportFormat;
import net.bull.javamelody.internal.model.VirtualMachine;
import net.bull.javamelody.internal.web.RequestToMethodMapper;

public class SerializableController {
    private static final String RANGE_KEY = "range";
    private static final String JAVA_INFORMATIONS_LIST_KEY = "javaInformationsList";
    private static final String MESSAGE_FOR_REPORT_KEY = "messageForReport";
    private static final RequestToMethodMapper<SerializableController> REQUEST_TO_METHOD_MAPPER = new RequestToMethodMapper<SerializableController>(SerializableController.class);
    private final Collector collector;

    public SerializableController(Collector collector) {
        assert (collector != null);
        this.collector = collector;
    }

    void doSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Serializable serializable) throws IOException {
        String format = HttpParameter.FORMAT.getParameterFrom(httpRequest);
        TransportFormat transportFormat = TransportFormat.valueOfIgnoreCase(format);
        transportFormat.checkDependencies();
        httpResponse.setContentType(transportFormat.getMimeType());
        String fileName = "JavaMelody_" + this.getApplication().replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + '.' + transportFormat.getCode();
        String contentDisposition = "inline;filename=" + fileName;
        httpResponse.addHeader("Content-Disposition", contentDisposition.replace('\n', '_').replace('\r', '_'));
        transportFormat.writeSerializableTo(serializable, (OutputStream)httpResponse.getOutputStream());
    }

    public Serializable createSerializable(HttpServletRequest httpRequest, List<JavaInformations> javaInformationsList, String messageForReport) throws IOException {
        Range range = this.getRangeForSerializable(httpRequest);
        if (HttpParameter.PART.getParameterFrom(httpRequest) != null) {
            httpRequest.setAttribute(JAVA_INFORMATIONS_LIST_KEY, javaInformationsList);
            httpRequest.setAttribute(RANGE_KEY, (Object)range);
            httpRequest.setAttribute(MESSAGE_FOR_REPORT_KEY, (Object)messageForReport);
            return (Serializable)REQUEST_TO_METHOD_MAPPER.invokeAndReturn(httpRequest, this);
        }
        if (HttpParameter.JMX_VALUE.getParameterFrom(httpRequest) != null) {
            Action.checkSystemActionsEnabled();
            String jmxValue = HttpParameter.JMX_VALUE.getParameterFrom(httpRequest);
            return MBeans.getConvertedAttributes(jmxValue);
        }
        return this.createDefaultSerializable(javaInformationsList, range, messageForReport);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.THREADS)
    Serializable createThreadsSerializable(@RequestToMethodMapper.RequestAttribute(value="javaInformationsList") List<JavaInformations> javaInformationsList) {
        return new ArrayList<ThreadInformations>(javaInformationsList.get(0).getThreadInformationsList());
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.COUNTER_SUMMARY_PER_CLASS)
    Serializable createCounterSummaryPerClassSerializable(@RequestToMethodMapper.RequestAttribute(value="range") Range range, @RequestToMethodMapper.RequestParameter(value=HttpParameter.COUNTER) String counterName, @RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String requestId) throws IOException {
        Counter counter = this.collector.getRangeCounter(range, counterName).clone();
        List<CounterRequest> requestList = new CounterRequestAggregation(counter).getRequestsAggregatedOrFilteredByClassName(requestId);
        return new ArrayList<CounterRequest>(requestList);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.CURRENT_REQUESTS)
    Serializable createCurrentRequestsSerializable(@RequestToMethodMapper.RequestAttribute(value="javaInformationsList") List<JavaInformations> javaInformationsList) {
        HashMap<JavaInformations, List<CounterRequestContext>> result = new HashMap<JavaInformations, List<CounterRequestContext>>();
        result.put(javaInformationsList.get(0), this.getCurrentRequests());
        return result;
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.DEFAULT_WITH_CURRENT_REQUESTS)
    Serializable createDefaultWithCurrentRequestsSerializable(@RequestToMethodMapper.RequestAttribute(value="javaInformationsList") List<JavaInformations> javaInformationsList, @RequestToMethodMapper.RequestAttribute(value="messageForReport") String messageForReport, @RequestToMethodMapper.RequestAttribute(value="range") Range range) throws IOException {
        ArrayList<CounterRequestContext> result = new ArrayList<CounterRequestContext>();
        result.addAll((List)((Object)this.createDefaultSerializable(javaInformationsList, range, messageForReport)));
        result.addAll(this.getCurrentRequests());
        return result;
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.JVM)
    Serializable createJvmSerializable(@RequestToMethodMapper.RequestAttribute(value="javaInformationsList") List<JavaInformations> javaInformationsList) {
        return new ArrayList<JavaInformations>(javaInformationsList);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.SESSIONS)
    Serializable createSessionsSerializable(@RequestToMethodMapper.RequestParameter(value=HttpParameter.SESSION_ID) String sessionId) {
        Action.checkSystemActionsEnabled();
        if (sessionId == null) {
            return new ArrayList<SessionInformations>(SessionListener.getAllSessionsInformations());
        }
        return SessionListener.getSessionInformationsBySessionId(sessionId);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.HOTSPOTS)
    Serializable createHotspotsSerializable() {
        Action.checkSystemActionsEnabled();
        return new ArrayList<SamplingProfiler.SampledMethod>(this.collector.getHotspots());
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.HEAP_HISTO)
    Serializable createHeapHistoSerializable() throws Exception {
        Action.checkSystemActionsEnabled();
        return VirtualMachine.createHeapHistogram();
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.PROCESSES)
    Serializable createProcessesSerializable() throws IOException {
        Action.checkSystemActionsEnabled();
        return new ArrayList<ProcessInformations>(ProcessInformations.buildProcessInformations());
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.JNDI)
    Serializable createJndiSerializable(@RequestToMethodMapper.RequestParameter(value=HttpParameter.PATH) String path) throws NamingException {
        Action.checkSystemActionsEnabled();
        return new ArrayList<JndiBinding>(JndiBinding.listBindings(path));
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.MBEANS)
    Serializable createMBeansSerializable() throws JMException {
        Action.checkSystemActionsEnabled();
        return new ArrayList<MBeanNode>(MBeans.getAllMBeanNodes());
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.DEPENDENCIES)
    Serializable createDependenciesSerializable() throws IOException {
        Action.checkSystemActionsEnabled();
        Map<String, MavenArtifact> webappDependencies = MavenArtifact.getWebappDependencies();
        for (MavenArtifact dependency : webappDependencies.values()) {
            if (dependency == null) continue;
            dependency.getLicenseUrlsByName();
        }
        return new TreeMap<String, MavenArtifact>(webappDependencies);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.LAST_VALUE)
    Serializable createLastValueSerializable(@RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String graph) throws IOException {
        if (graph != null) {
            JRobin jrobin = this.collector.getJRobin(graph);
            double lastValue = jrobin == null ? -1.0 : jrobin.getLastValue();
            return Double.valueOf(lastValue);
        }
        Collection<JRobin> jrobins = this.collector.getDisplayedCounterJRobins();
        LinkedHashMap<String, Double> lastValues = new LinkedHashMap<String, Double>(jrobins.size());
        for (JRobin jrobin : jrobins) {
            lastValues.put(jrobin.getName(), jrobin.getLastValue());
        }
        return lastValues;
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.DATABASE)
    Serializable createDatabaseSerializable(@RequestToMethodMapper.RequestParameter(value=HttpParameter.REQUEST) String requestIndex) throws SQLException, NamingException {
        Action.checkSystemActionsEnabled();
        int index = DatabaseInformations.parseRequestIndex(requestIndex);
        return new DatabaseInformations(index);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.CONNECTIONS)
    Serializable createConnectionsSerializable() {
        Action.checkSystemActionsEnabled();
        return new ArrayList<ConnectionInformations>(JdbcWrapper.getConnectionInformationsList());
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.WEBAPP_VERSIONS)
    Serializable createWebappVersionsSerializable() {
        return new LinkedHashMap<String, Date>(this.collector.getDatesByWebappVersions());
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.GRAPH)
    Serializable getCounterRequestById(@RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String requestId, @RequestToMethodMapper.RequestAttribute(value="range") Range range) throws IOException {
        for (Counter counter : this.collector.getCounters()) {
            if (!counter.isRequestIdFromThisCounter(requestId)) continue;
            Counter rangeCounter = this.collector.getRangeCounter(range, counter.getName()).clone();
            for (CounterRequest request : rangeCounter.getRequests()) {
                if (!requestId.equals(request.getId())) continue;
                return request;
            }
        }
        return null;
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.JROBINS)
    Serializable getJRobinsImages(@RequestToMethodMapper.RequestAttribute(value="range") Range range, @RequestToMethodMapper.RequestParameter(value=HttpParameter.WIDTH) String width, @RequestToMethodMapper.RequestParameter(value=HttpParameter.HEIGHT) String height, @RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String graphName) throws IOException {
        int myWidth = Integer.parseInt(width);
        int myHeight = Integer.parseInt(height);
        if (graphName != null) {
            JRobin jrobin = this.collector.getJRobin(graphName);
            if (jrobin != null) {
                return jrobin.graph(range, myWidth, myHeight);
            }
            return null;
        }
        Collection<JRobin> jrobins = this.collector.getDisplayedCounterJRobins();
        return (Serializable)((Object)this.convertJRobinsToImages(jrobins, range, myWidth, myHeight));
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.OTHER_JROBINS)
    Serializable getOtherJRobinsImages(@RequestToMethodMapper.RequestAttribute(value="range") Range range, @RequestToMethodMapper.RequestParameter(value=HttpParameter.WIDTH) String width, @RequestToMethodMapper.RequestParameter(value=HttpParameter.HEIGHT) String height) throws IOException {
        Collection<JRobin> jrobins = this.collector.getDisplayedOtherJRobins();
        return (Serializable)((Object)this.convertJRobinsToImages(jrobins, range, Integer.parseInt(width), Integer.parseInt(height)));
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.EXPLAIN_PLAN)
    Serializable createExplainPlanSerializableFor(@RequestToMethodMapper.RequestParameter(value=HttpParameter.REQUEST) String sqlRequest) {
        assert (sqlRequest != null);
        try {
            return DatabaseInformations.explainPlanFor(sqlRequest);
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    private List<CounterRequestContext> getCurrentRequests() {
        List<Counter> counters = this.collector.getCounters();
        ArrayList<Counter> newCounters = new ArrayList<Counter>();
        for (Counter counter : counters) {
            Counter cloneLight = new Counter(counter.getName(), counter.getStorageName(), counter.getIconName(), counter.getChildCounterName());
            newCounters.add(cloneLight);
        }
        return this.collector.getRootCurrentContexts(newCounters);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.CRASHES)
    Serializable createCrashesSerializable(@RequestToMethodMapper.RequestAttribute(value="javaInformationsList") List<JavaInformations> javaInformationsList) {
        return new ArrayList<HsErrPid>(HsErrPid.getHsErrPidList(javaInformationsList));
    }

    private Map<String, byte[]> convertJRobinsToImages(Collection<JRobin> jrobins, Range range, int width, int height) throws IOException {
        LinkedHashMap<String, byte[]> images = new LinkedHashMap<String, byte[]>(jrobins.size());
        for (JRobin jrobin : jrobins) {
            byte[] image = jrobin.graph(range, width, height);
            images.put(jrobin.getName(), image);
        }
        return images;
    }

    public Serializable createDefaultSerializable(List<JavaInformations> javaInformationsList, Range range, String messageForReport) throws IOException {
        List<Counter> counters = this.collector.getRangeCounters(range);
        ArrayList<Object> serialized = new ArrayList<Object>(counters.size() + javaInformationsList.size());
        for (Counter counter : counters) {
            serialized.add(counter.clone());
        }
        serialized.addAll(javaInformationsList);
        if (messageForReport != null) {
            serialized.add(messageForReport);
        }
        return serialized;
    }

    public Range getRangeForSerializable(HttpServletRequest httpRequest) {
        Range range;
        String period = HttpParameter.PERIOD.getParameterFrom(httpRequest);
        if (period == null) {
            range = Period.TOUT.getRange();
        } else {
            String pattern = HttpParameter.PATTERN.getParameterFrom(httpRequest);
            DateFormat dateFormat = pattern == null ? I18N.createDateFormat() : new SimpleDateFormat(pattern, Locale.US);
            range = Range.parse(period, dateFormat);
        }
        return range;
    }

    private String getApplication() {
        return this.collector.getApplication();
    }
}

