/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;

public class AuthTeambitionRequest
extends AuthDefaultRequest {
    public AuthTeambitionRequest(AuthConfig config) {
        super(config, AuthSource.TEAMBITION);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HttpResponse response = HttpRequest.post((String)this.source.accessToken()).form("client_id", (Object)this.config.getClientId()).form("client_secret", (Object)this.config.getClientSecret()).form("code", (Object)authCallback.getCode()).form("grant_type", (Object)"code").execute();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response.body());
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)this.source.userInfo()).header("Authorization", "OAuth2 " + accessToken)).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        this.checkResponse(object);
        authToken.setUid(object.getString("_id"));
        return AuthUser.builder().uuid(object.getString("_id")).username(object.getString("name")).nickname(object.getString("name")).avatar(object.getString("avatarUrl")).blog(object.getString("website")).location(object.getString("location")).email(object.getString("email")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        String uid = oldToken.getUid();
        String refreshToken = oldToken.getRefreshToken();
        HttpResponse response = HttpRequest.post((String)this.source.refresh()).form("_userId", (Object)uid).form("refresh_token", (Object)refreshToken).execute();
        JSONObject refreshTokenObject = JSONObject.parseObject((String)response.body());
        this.checkResponse(refreshTokenObject);
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(AuthToken.builder().accessToken(refreshTokenObject.getString("access_token")).refreshToken(refreshTokenObject.getString("refresh_token")).build()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"message") && object.containsKey((Object)"name")) {
            throw new AuthException(object.getString("name") + ", " + object.getString("message"));
        }
    }
}

