/*
 * Decompiled with CFR 0.152.
 */
package me.ihxq.projects.pna.algorithm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import me.ihxq.projects.pna.Attribution;
import me.ihxq.projects.pna.ISP;
import me.ihxq.projects.pna.PhoneNumberInfo;
import me.ihxq.projects.pna.algorithm.LookupAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProspectBinarySearchAlgorithmImpl
implements LookupAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(ProspectBinarySearchAlgorithmImpl.class);
    private ByteBuffer originalByteBuffer;
    private int indicesStartOffset;
    private int indicesEndOffset;

    @Override
    public void loadData(byte[] data) {
        this.originalByteBuffer = ByteBuffer.wrap(data).asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        int dataVersion = this.originalByteBuffer.getInt();
        this.indicesStartOffset = this.originalByteBuffer.getInt(4);
        this.indicesEndOffset = this.originalByteBuffer.capacity();
    }

    private int alignPosition(int pos) {
        int remain = (pos - this.indicesStartOffset) % 9;
        if (pos - this.indicesStartOffset < 9) {
            return pos - remain;
        }
        if (remain != 0) {
            return pos + 9 - remain;
        }
        return pos;
    }

    private boolean isInvalidPhoneNumber(String phoneNumber) {
        if (phoneNumber == null) {
            log.debug("phone number is null");
            return true;
        }
        int phoneNumberLength = phoneNumber.length();
        if (phoneNumberLength < 7 || phoneNumberLength > 11) {
            log.debug("phone number {} is not acceptable, length invalid, length should be 11 or 7(for left 7 numbers), actual: {}", (Object)phoneNumber, (Object)phoneNumberLength);
            return true;
        }
        return false;
    }

    @Override
    public Optional<PhoneNumberInfo> lookup(String phoneNumber) {
        int attributionIdentity;
        log.trace("try to resolve attribution of phone number: {}", (Object)phoneNumber);
        ByteBuffer byteBuffer = this.originalByteBuffer.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        if (this.isInvalidPhoneNumber(phoneNumber)) {
            return Optional.empty();
        }
        try {
            attributionIdentity = Integer.parseInt(phoneNumber.substring(0, 7));
        }
        catch (NumberFormatException e) {
            log.debug("phone number {} is invalid, is it numeric?", (Object)phoneNumber);
            return Optional.empty();
        }
        int left = this.indicesStartOffset;
        int right = this.indicesEndOffset;
        int attributionIdentityPrefix = attributionIdentity / 100000;
        int mid = this.indicesStartOffset + (this.indicesEndOffset - this.indicesStartOffset) / 7 * (attributionIdentityPrefix - 13);
        mid = this.alignPosition(mid);
        while (mid >= left && mid <= right) {
            int tempMid;
            if (mid == right) {
                return Optional.empty();
            }
            int compare = this.compare(mid, attributionIdentity, byteBuffer);
            if (compare == 0) {
                return this.extract(phoneNumber, mid, byteBuffer);
            }
            if (mid == left) {
                return Optional.empty();
            }
            if (compare > 0) {
                tempMid = (mid + left) / 2;
                right = mid;
                mid = this.alignPosition(tempMid);
                continue;
            }
            tempMid = (mid + right) / 2;
            left = mid;
            mid = this.alignPosition(tempMid);
        }
        return Optional.empty();
    }

    private Optional<PhoneNumberInfo> extract(String phoneNumber, int indexStart, ByteBuffer byteBuffer) {
        byteBuffer.position(indexStart);
        int prefix = byteBuffer.getInt();
        int infoStartIndex = byteBuffer.getInt();
        byte ispMark = byteBuffer.get();
        ISP isp = ISP.of(ispMark).orElse(ISP.UNKNOWN);
        byte[] bytes = new byte[this.determineInfoLength(infoStartIndex, byteBuffer)];
        byteBuffer.get(bytes);
        String oriString = new String(bytes);
        Attribution attribution = this.parse(oriString);
        return Optional.of(new PhoneNumberInfo(phoneNumber, attribution, isp));
    }

    private int determineInfoLength(int infoStartIndex, ByteBuffer byteBuffer) {
        byteBuffer.position(infoStartIndex);
        while (byteBuffer.get() != 0) {
        }
        int infoEnd = byteBuffer.position() - 1;
        byteBuffer.position(infoStartIndex);
        return infoEnd - infoStartIndex;
    }

    private Attribution parse(String ori) {
        String[] split = ori.split("\\|");
        if (split.length < 4) {
            throw new IllegalStateException("content format error");
        }
        return Attribution.builder().province(split[0]).city(split[1]).zipCode(split[2]).areaCode(split[3]).build();
    }

    private int compare(int position, int key, ByteBuffer byteBuffer) {
        byteBuffer.position(position);
        int phonePrefix = byteBuffer.getInt();
        return Integer.compare(phonePrefix, key);
    }
}

