/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Range;
import java.util.Collection;
import javax.annotation.Nonnull;
import me.ahoo.cosid.sharding.Sharding;

@Beta
public class CachedSharding<T extends Comparable<?>>
implements Sharding<T> {
    private final Sharding<T> actual;
    private final LoadingCache<Range<T>, Collection<String>> shardingCache;

    public CachedSharding(Sharding<T> actual) {
        this.actual = actual;
        this.shardingCache = CacheBuilder.newBuilder().build((CacheLoader)new LoadShardingCache());
    }

    @Override
    @Nonnull
    public String sharding(T shardingValue) {
        return this.actual.sharding(shardingValue);
    }

    @Override
    @Nonnull
    public Collection<String> sharding(Range<T> shardingValue) {
        return (Collection)this.shardingCache.getUnchecked(shardingValue);
    }

    @Override
    @Nonnull
    public Collection<String> getEffectiveNodes() {
        return this.actual.getEffectiveNodes();
    }

    private class LoadShardingCache
    extends CacheLoader<Range<T>, Collection<String>> {
        private LoadShardingCache() {
        }

        public Collection<String> load(@Nonnull Range<T> key) {
            return CachedSharding.this.actual.sharding(key);
        }
    }
}

