/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.machine;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineState;

public class MachineIdLostException
extends CosIdException {
    private final String namespace;
    private final InstanceId instanceId;
    private final MachineState machineState;

    public MachineIdLostException(String namespace, InstanceId instanceId, @Nullable MachineState machineState) {
        super(Strings.lenientFormat((String)"The machine id[%s] bound to the instance[%s]@[%s] has been lost!.", (Object[])new Object[]{machineState, instanceId, namespace}));
        this.namespace = namespace;
        this.instanceId = instanceId;
        this.machineState = machineState;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public MachineState getMachineState() {
        return this.machineState;
    }
}

