/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.machine;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class InstanceId {
    public static final InstanceId NONE = new InstanceId("none", false);
    private final String instanceId;
    private final boolean stable;

    public InstanceId(String instanceId, boolean stable) {
        this.instanceId = instanceId;
        this.stable = stable;
    }

    public boolean isStable() {
        return this.stable;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("instanceId", (Object)this.instanceId).add("stable", this.stable).toString();
    }

    public static InstanceId of(String host, int port, boolean stable) {
        String instanceIdStr = String.format("%s:%s", host, port);
        return InstanceId.of(instanceIdStr, stable);
    }

    public static InstanceId of(String instanceId, boolean stable) {
        return new InstanceId(instanceId, stable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceId)) {
            return false;
        }
        InstanceId that = (InstanceId)o;
        return this.stable == that.stable && Objects.equal((Object)this.instanceId, (Object)that.instanceId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instanceId, this.stable});
    }
}

