/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrectedResultCollector
extends ResultCollector {
    private static final Logger log = LoggerFactory.getLogger(CorrectedResultCollector.class);
    public static final String INCLUDE_SAMPLE_LABELS = "include_sample_labels";
    public static final String EXCLUDE_SAMPLE_LABELS = "exclude_sample_labels";
    public static final String INCLUDE_REGEX_CHECKBOX_STATE = "include_checkbox_state";
    public static final String EXCLUDE_REGEX_CHECKBOX_STATE = "exclude_checkbox_state";
    public static final String START_OFFSET = "start_offset";
    public static final String END_OFFSET = "end_offset";
    public static final String PREFIX_LABEL = "prefix_label";
    public static final String EMPTY_FIELD = "";
    private static final String COMMA = ",";

    public void testStarted() {
        this.setupSaving();
        super.testStarted();
    }

    public void testStarted(String host) {
        this.setupSaving();
        super.testStarted(host);
    }

    private void setupSaving() {
        SampleSaveConfiguration conf = this.getSaveConfig();
        conf.setThreadCounts(true);
    }

    public List<String> getList(String prop) {
        String s = this.getPropertyAsString(prop);
        if (s.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return Arrays.asList(s.split(COMMA));
    }

    public String getRegex(String prop) {
        return this.getPropertyAsString(prop);
    }

    public void setExcludeLabels(String excludeLabels) {
        this.setProperty(EXCLUDE_SAMPLE_LABELS, excludeLabels);
    }

    public void setIncludeLabels(String includesLabels) {
        this.setProperty(INCLUDE_SAMPLE_LABELS, includesLabels);
    }

    public void setEnabledIncludeRegex(boolean prop) {
        this.setProperty(INCLUDE_REGEX_CHECKBOX_STATE, prop);
    }

    public void setEnabledExcludeRegex(boolean prop) {
        this.setProperty(EXCLUDE_REGEX_CHECKBOX_STATE, prop);
    }

    public long getTimeDelimiter(String prop, long indice) {
        String number = this.getPropertyAsString(prop);
        if (!number.isEmpty() && number.length() < 19 && number.matches("^[1-9][0-9]*")) {
            return Long.valueOf(number) * 1000L;
        }
        return indice;
    }

    public boolean getRegexChkboxState(String prop) {
        return this.getPropertyAsBoolean(prop);
    }

    public void setStartOffset(String startOffset) {
        this.setProperty(START_OFFSET, startOffset);
    }

    public void setEndOffset(String endOffset) {
        this.setProperty(END_OFFSET, endOffset);
    }

    public void setPrefixLabel(String prefixLabel) {
        this.setProperty(PREFIX_LABEL, prefixLabel);
    }

    public String getPrefixLabel(String prop) {
        return this.getPropertyAsString(prop);
    }
}

