/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelToColorMapping {
    private static final Logger log = LoggerFactory.getLogger(LabelToColorMapping.class);
    private static Map<String, Color> standardHtmlColorNames = null;
    private Map<String, Color> labelToColorMapping = new Hashtable<String, Color>();

    public LabelToColorMapping() {
        this.loadStandardHtmlColors();
    }

    public Color parseStandardHtmlColor(String someKindOfColorDescription) {
        String hexColor;
        int intColor;
        Color c = standardHtmlColorNames.get(someKindOfColorDescription.toLowerCase());
        if (c == null && someKindOfColorDescription.trim().startsWith("#") && someKindOfColorDescription.length() >= 2 && (intColor = Integer.parseInt(hexColor = someKindOfColorDescription.substring(1), 16)) > 0 && intColor < 0x1010000) {
            c = new Color(intColor);
        }
        return c;
    }

    public void addStandardHtmlColor(String colorName, Color c) {
        standardHtmlColorNames.put(colorName.toLowerCase().trim(), c);
    }

    public Color getColorForLabel(String label) {
        Iterator<Map.Entry<String, Color>> it = this.labelToColorMapping.entrySet().iterator();
        Color rc = null;
        while (it.hasNext()) {
            Map.Entry<String, Color> entry = it.next();
            if (log.isDebugEnabled()) {
                log.debug("Label [" + label + "] entry.getKey[" + entry.getKey() + "]");
            }
            if (!label.toLowerCase().contains(entry.getKey())) continue;
            rc = entry.getValue();
            break;
        }
        return rc;
    }

    public void addMapping(String label, Color c) {
        this.labelToColorMapping.put(label.toLowerCase().trim(), c);
    }

    public static LabelToColorMapping load(String colorConfigString) {
        LabelToColorMapping mapping = null;
        if (colorConfigString != null && colorConfigString.length() >= 3) {
            String[] manyMappings;
            mapping = new LabelToColorMapping();
            for (String oneMapping : manyMappings = colorConfigString.split(":")) {
                String[] twoParts = oneMapping.split("=");
                if (twoParts.length != 2) {
                    throw new RuntimeException("Was expecting color mapping config in this format:  myLabel1=Red:myLabel2=Blue:myLabel3=Green.  Instead found [" + colorConfigString + "]");
                }
                Color c = mapping.parseStandardHtmlColor(twoParts[1]);
                if (c == null) {
                    throw new RuntimeException("Expecting the text [" + twoParts[1] + "] to be a name or RGB hex value of a color.  Entire config string: [" + colorConfigString + "]");
                }
                mapping.addMapping(twoParts[0], c);
            }
        }
        return mapping;
    }

    private void loadStandardHtmlColors() {
        if (standardHtmlColorNames == null) {
            standardHtmlColorNames = new Hashtable<String, Color>();
            this.addStandardHtmlColor("AliceBlue", new Color(0xF0F8FF));
            this.addStandardHtmlColor("AntiqueWhite", new Color(16444375));
            this.addStandardHtmlColor("Aqua", new Color(65535));
            this.addStandardHtmlColor("Aquamarine", new Color(8388564));
            this.addStandardHtmlColor("Azure", new Color(0xF0FFFF));
            this.addStandardHtmlColor("Beige", new Color(16119260));
            this.addStandardHtmlColor("Bisque", new Color(16770244));
            this.addStandardHtmlColor("Black", new Color(0));
            this.addStandardHtmlColor("BlanchedAlmond", new Color(16772045));
            this.addStandardHtmlColor("Blue", new Color(255));
            this.addStandardHtmlColor("BlueViolet", new Color(9055202));
            this.addStandardHtmlColor("Brown", new Color(0xA52A2A));
            this.addStandardHtmlColor("BurlyWood", new Color(14596231));
            this.addStandardHtmlColor("CadetBlue", new Color(6266528));
            this.addStandardHtmlColor("Chartreuse", new Color(0x7FFF00));
            this.addStandardHtmlColor("Chocolate", new Color(13789470));
            this.addStandardHtmlColor("Coral", new Color(16744272));
            this.addStandardHtmlColor("CornflowerBlue", new Color(6591981));
            this.addStandardHtmlColor("Cornsilk", new Color(16775388));
            this.addStandardHtmlColor("Crimson", new Color(14423100));
            this.addStandardHtmlColor("Cyan", new Color(65535));
            this.addStandardHtmlColor("DarkBlue", new Color(139));
            this.addStandardHtmlColor("DarkCyan", new Color(35723));
            this.addStandardHtmlColor("DarkGoldenRod", new Color(12092939));
            this.addStandardHtmlColor("DarkGray", new Color(0xA9A9A9));
            this.addStandardHtmlColor("DarkGreen", new Color(25600));
            this.addStandardHtmlColor("DarkKhaki", new Color(12433259));
            this.addStandardHtmlColor("DarkMagenta", new Color(0x8B008B));
            this.addStandardHtmlColor("DarkOliveGreen", new Color(5597999));
            this.addStandardHtmlColor("DarkOrange", new Color(16747520));
            this.addStandardHtmlColor("DarkOrchid", new Color(10040012));
            this.addStandardHtmlColor("DarkRed", new Color(0x8B0000));
            this.addStandardHtmlColor("DarkSalmon", new Color(15308410));
            this.addStandardHtmlColor("DarkSeaGreen", new Color(9419919));
            this.addStandardHtmlColor("DarkSlateBlue", new Color(4734347));
            this.addStandardHtmlColor("DarkSlateGray", new Color(0x2F4F4F));
            this.addStandardHtmlColor("DarkTurquoise", new Color(52945));
            this.addStandardHtmlColor("DarkViolet", new Color(9699539));
            this.addStandardHtmlColor("DeepPink", new Color(16716947));
            this.addStandardHtmlColor("DeepSkyBlue", new Color(49151));
            this.addStandardHtmlColor("DimGray", new Color(0x696969));
            this.addStandardHtmlColor("DodgerBlue", new Color(2003199));
            this.addStandardHtmlColor("FireBrick", new Color(0xB22222));
            this.addStandardHtmlColor("FloralWhite", new Color(0xFFFAF0));
            this.addStandardHtmlColor("ForestGreen", new Color(0x228B22));
            this.addStandardHtmlColor("Fuchsia", new Color(0xFF00FF));
            this.addStandardHtmlColor("Gainsboro", new Color(0xDCDCDC));
            this.addStandardHtmlColor("GhostWhite", new Color(0xF8F8FF));
            this.addStandardHtmlColor("Gold", new Color(16766720));
            this.addStandardHtmlColor("GoldenRod", new Color(14329120));
            this.addStandardHtmlColor("Gray", new Color(0x808080));
            this.addStandardHtmlColor("Green", new Color(32768));
            this.addStandardHtmlColor("GreenYellow", new Color(11403055));
            this.addStandardHtmlColor("HoneyDew", new Color(0xF0FFF0));
            this.addStandardHtmlColor("HotPink", new Color(16738740));
            this.addStandardHtmlColor("IndianRed ", new Color(0xCD5C5C));
            this.addStandardHtmlColor("Indigo ", new Color(4915330));
            this.addStandardHtmlColor("Ivory", new Color(0xFFFFF0));
            this.addStandardHtmlColor("Khaki", new Color(15787660));
            this.addStandardHtmlColor("Lavender", new Color(15132410));
            this.addStandardHtmlColor("LavenderBlush", new Color(0xFFF0F5));
            this.addStandardHtmlColor("LawnGreen", new Color(8190976));
            this.addStandardHtmlColor("LemonChiffon", new Color(16775885));
            this.addStandardHtmlColor("LightBlue", new Color(11393254));
            this.addStandardHtmlColor("LightCoral", new Color(0xF08080));
            this.addStandardHtmlColor("LightCyan", new Color(0xE0FFFF));
            this.addStandardHtmlColor("LightGoldenRodYellow", new Color(16448210));
            this.addStandardHtmlColor("LightGray", new Color(0xD3D3D3));
            this.addStandardHtmlColor("LightGreen", new Color(0x90EE90));
            this.addStandardHtmlColor("LightPink", new Color(16758465));
            this.addStandardHtmlColor("LightSalmon", new Color(16752762));
            this.addStandardHtmlColor("LightSeaGreen", new Color(2142890));
            this.addStandardHtmlColor("LightSkyBlue", new Color(8900346));
            this.addStandardHtmlColor("LightSlateGray", new Color(0x778899));
            this.addStandardHtmlColor("LightSteelBlue", new Color(11584734));
            this.addStandardHtmlColor("LightYellow", new Color(0xFFFFE0));
            this.addStandardHtmlColor("Lime", new Color(65280));
            this.addStandardHtmlColor("LimeGreen", new Color(3329330));
            this.addStandardHtmlColor("Linen", new Color(16445670));
            this.addStandardHtmlColor("Magenta", new Color(0xFF00FF));
            this.addStandardHtmlColor("Maroon", new Color(0x800000));
            this.addStandardHtmlColor("MediumAquaMarine", new Color(6737322));
            this.addStandardHtmlColor("MediumBlue", new Color(205));
            this.addStandardHtmlColor("MediumOrchid", new Color(12211667));
            this.addStandardHtmlColor("MediumPurple", new Color(9662683));
            this.addStandardHtmlColor("MediumSeaGreen", new Color(3978097));
            this.addStandardHtmlColor("MediumSlateBlue", new Color(8087790));
            this.addStandardHtmlColor("MediumSpringGreen", new Color(64154));
            this.addStandardHtmlColor("MediumTurquoise", new Color(4772300));
            this.addStandardHtmlColor("MediumVioletRed", new Color(13047173));
            this.addStandardHtmlColor("MidnightBlue", new Color(1644912));
            this.addStandardHtmlColor("MintCream", new Color(0xF5FFFA));
            this.addStandardHtmlColor("MistyRose", new Color(16770273));
            this.addStandardHtmlColor("Moccasin", new Color(16770229));
            this.addStandardHtmlColor("NavajoWhite", new Color(16768685));
            this.addStandardHtmlColor("Navy", new Color(128));
            this.addStandardHtmlColor("OldLace", new Color(16643558));
            this.addStandardHtmlColor("Olive", new Color(0x808000));
            this.addStandardHtmlColor("OliveDrab", new Color(7048739));
            this.addStandardHtmlColor("Orange", new Color(16753920));
            this.addStandardHtmlColor("OrangeRed", new Color(16729344));
            this.addStandardHtmlColor("Orchid", new Color(14315734));
            this.addStandardHtmlColor("PaleGoldenRod", new Color(0xEEE8AA));
            this.addStandardHtmlColor("PaleGreen", new Color(10025880));
            this.addStandardHtmlColor("PaleTurquoise", new Color(0xAFEEEE));
            this.addStandardHtmlColor("PaleVioletRed", new Color(14381203));
            this.addStandardHtmlColor("PapayaWhip", new Color(16773077));
            this.addStandardHtmlColor("PeachPuff", new Color(16767673));
            this.addStandardHtmlColor("Peru", new Color(13468991));
            this.addStandardHtmlColor("Pink", new Color(16761035));
            this.addStandardHtmlColor("Plum", new Color(0xDDA0DD));
            this.addStandardHtmlColor("PowderBlue", new Color(11591910));
            this.addStandardHtmlColor("Purple", new Color(0x800080));
            this.addStandardHtmlColor("RebeccaPurple", new Color(0x663399));
            this.addStandardHtmlColor("Red", new Color(0xFF0000));
            this.addStandardHtmlColor("RosyBrown", new Color(12357519));
            this.addStandardHtmlColor("RoyalBlue", new Color(4286945));
            this.addStandardHtmlColor("SaddleBrown", new Color(9127187));
            this.addStandardHtmlColor("Salmon", new Color(16416882));
            this.addStandardHtmlColor("SandyBrown", new Color(16032864));
            this.addStandardHtmlColor("SeaGreen", new Color(3050327));
            this.addStandardHtmlColor("SeaShell", new Color(0xFFF5EE));
            this.addStandardHtmlColor("Sienna", new Color(10506797));
            this.addStandardHtmlColor("Silver", new Color(0xC0C0C0));
            this.addStandardHtmlColor("SkyBlue", new Color(8900331));
            this.addStandardHtmlColor("SlateBlue", new Color(6970061));
            this.addStandardHtmlColor("SlateGray", new Color(7372944));
            this.addStandardHtmlColor("Snow", new Color(0xFFFAFA));
            this.addStandardHtmlColor("SpringGreen", new Color(65407));
            this.addStandardHtmlColor("SteelBlue", new Color(4620980));
            this.addStandardHtmlColor("Tan", new Color(13808780));
            this.addStandardHtmlColor("Teal", new Color(32896));
            this.addStandardHtmlColor("Thistle", new Color(14204888));
            this.addStandardHtmlColor("Tomato", new Color(16737095));
            this.addStandardHtmlColor("Turquoise", new Color(4251856));
            this.addStandardHtmlColor("Violet", new Color(0xEE82EE));
            this.addStandardHtmlColor("Wheat", new Color(16113331));
            this.addStandardHtmlColor("White", new Color(0xFFFFFF));
            this.addStandardHtmlColor("WhiteSmoke", new Color(0xF5F5F5));
            this.addStandardHtmlColor("Yellow", new Color(0xFFFF00));
            this.addStandardHtmlColor("YellowGreen", new Color(10145074));
            log.debug("Standard HTML color names loaded.");
        }
    }
}

