/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.ChartSettings;
import kg.apc.charting.ColorsDispatcher;
import kg.apc.charting.ColorsDispatcherFactory;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.charting.GraphModelToCsvExporter;
import kg.apc.charting.plotters.AbstractRowPlotter;
import kg.apc.charting.plotters.BarRowPlotter;
import kg.apc.charting.plotters.CSplineRowPlotter;
import kg.apc.charting.plotters.LineRowPlotter;
import kg.apc.jmeter.gui.CustomNumberRenderer;
import org.apache.jorphan.gui.NumberRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPanelChart
extends JComponent
implements ClipboardOwner {
    private static BufferedImage cache = null;
    private static int cacheWitdh;
    private static int cacheHeight;
    private boolean cacheValid = false;
    private static int cacheOwner;
    private int gpcId;
    private static int uidGenerator;
    BarRowPlotter barRowPlotter = null;
    LineRowPlotter lineRowPlotter = null;
    CSplineRowPlotter cSplineRowPlotter = null;
    AbstractRowPlotter currentPlotter = null;
    JPopupMenu popup = new JPopupMenu();
    private static final String AD_TEXT = "jmeter-plugins.org";
    private static final String NO_SAMPLES = "Waiting for samples...";
    private static final int spacing = 5;
    private static final int previewInset = 4;
    public static final int CHART_PERCENTAGE = 0;
    public static final int CHART_DEFAULT = -1;
    private static final Logger log;
    private Rectangle legendRect;
    private Rectangle xAxisRect;
    private Rectangle yAxisRect;
    private Rectangle chartRect;
    private static final Rectangle zeroRect;
    private AbstractMap<String, AbstractGraphRow> rows;
    private double maxYVal;
    private double minYVal;
    private long maxXVal;
    private long minXVal;
    private long currentXVal;
    private static final int gridLinesCount = 10;
    private NumberRenderer yAxisLabelRenderer;
    private NumberRenderer xAxisLabelRenderer;
    private long forcedMinX = -1L;
    private int chartType = -1;
    private String errorMessage = null;
    private static final Color gradientColor;
    private static final Color axisColor;
    private static String savePath;
    private ChartSettings chartSettings = new ChartSettings();
    private CustomNumberRenderer nbFormatter = new CustomNumberRenderer("#,#00.#", ' ');
    private static final int legendAdjust = 3;
    private boolean reSetColors = false;
    private JWindow hoverWindow;
    private static final int hoverGap = 20;
    private boolean forceHoverPosition = true;
    private JTextField hoverLabel;
    private int xHoverInfo = -1;
    private int yHoverInfo = -1;
    private HoverMotionListener motionListener = new HoverMotionListener();
    private String xAxisLabel = "X axis label";
    private String yAxisLabel = "Y axis label";
    private int precisionLabel = -1;
    private int limitPointFactor = 1;
    private boolean displayPrecision = false;
    private boolean isPreview = false;
    private long testStartTime = 0L;
    private HashMap<String, Double> rowsZoomFactor = new HashMap();

    public ChartSettings getChartSettings() {
        return this.chartSettings;
    }

    public void setReSetColors(boolean reSetColors) {
        this.reSetColors = reSetColors;
    }

    public void setDisplayPrecision(boolean displayPrecision) {
        this.displayPrecision = displayPrecision;
    }

    public void setxAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public void setPrecisionLabel(int precision) {
        this.precisionLabel = precision;
    }

    private void autoZoom_orig() {
        if (!this.chartSettings.isExpendRows()) {
            return;
        }
        for (Map.Entry<String, AbstractGraphRow> row : this.rows.entrySet()) {
            double[] minMax = row.getValue().getMinMaxY(this.chartSettings.getMaxPointPerRow());
            if (minMax[1] > 0.0) {
                double zoomFactor = 1.0;
                this.rowsZoomFactor.put(row.getKey(), zoomFactor);
                while (minMax[1] * zoomFactor <= this.maxYVal) {
                    this.rowsZoomFactor.put(row.getKey(), zoomFactor);
                    zoomFactor *= 10.0;
                }
                continue;
            }
            this.rowsZoomFactor.put(row.getKey(), 1.0);
        }
    }

    private String getXAxisLabel() {
        String label;
        if (!this.displayPrecision) {
            label = this.xAxisLabel;
        } else {
            long granularity = this.chartSettings.getMaxPointPerRow() <= 0 ? (long)this.precisionLabel : (long)(this.precisionLabel * this.limitPointFactor);
            long min = granularity / 60000L;
            long sec = granularity % 60000L / 1000L;
            long ms = granularity % 60000L % 1000L;
            label = this.xAxisLabel + " (granularity:";
            if (min > 0L) {
                label = label + " " + min + " min";
            }
            if (sec > 0L || min > 0L && ms > 0L) {
                if (min > 0L) {
                    label = label + ",";
                }
                label = label + " " + sec + " sec";
            }
            if (ms > 0L) {
                if (sec > 0L || min > 0L) {
                    label = label + ",";
                }
                label = label + " " + ms + " ms";
            }
            label = label + ")";
        }
        return label;
    }

    public void setIsPreview(boolean isPreview) {
        this.isPreview = isPreview;
        if (!isPreview) {
            this.setComponentPopupMenu(this.popup);
        } else {
            this.setComponentPopupMenu(null);
        }
    }

    public void setTestStartTime(long time) {
        this.testStartTime = time;
    }

    private static synchronized int getNextId() {
        return ++uidGenerator;
    }

    public GraphPanelChart(boolean allowCsvExport, boolean haveGUI) {
        this.gpcId = GraphPanelChart.getNextId();
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.darkGray));
        this.yAxisLabelRenderer = new CustomNumberRenderer("#,###.#", ' ');
        this.xAxisLabelRenderer = new CustomNumberRenderer("#,###.#", ' ');
        this.legendRect = new Rectangle();
        this.yAxisRect = new Rectangle();
        this.xAxisRect = new Rectangle();
        this.chartRect = new Rectangle();
        if (haveGUI && !GraphicsEnvironment.isHeadless()) {
            this.registerPopup(allowCsvExport);
            this.hoverLabel = new JTextField();
            this.hoverLabel.setEditable(false);
            this.hoverLabel.setOpaque(false);
            this.hoverLabel.setBorder(new BevelBorder(0));
            this.hoverLabel.setFont(new Font("Tahoma", 0, 11));
            this.hoverWindow = new JWindow();
            this.hoverWindow.setBackground(gradientColor);
            this.hoverWindow.add((Component)this.hoverLabel, "Center");
            this.registerHoverInfo();
        }
        this.barRowPlotter = new BarRowPlotter(this.chartSettings, this.yAxisLabelRenderer);
        this.lineRowPlotter = new LineRowPlotter(this.chartSettings, this.yAxisLabelRenderer);
        this.cSplineRowPlotter = new CSplineRowPlotter(this.chartSettings, this.yAxisLabelRenderer);
    }

    public GraphPanelChart(boolean haveGUI) {
        this(true, haveGUI);
    }

    public GraphPanelChart() {
        this(false);
    }

    public boolean isModelContainsRow(AbstractGraphRow row) {
        return this.rows.containsKey(row.getLabel());
    }

    public void setChartType(int type) {
        this.chartType = type;
    }

    private boolean drawMessages(Graphics2D g) {
        if (this.errorMessage != null) {
            g.setColor(Color.RED);
            g.drawString(this.errorMessage, g.getClipBounds().width / 2 - g.getFontMetrics(g.getFont()).stringWidth(this.errorMessage) / 2, g.getClipBounds().height / 2);
            return true;
        }
        if (this.rows.isEmpty()) {
            g.setColor(Color.BLACK);
            g.drawString(NO_SAMPLES, g.getClipBounds().width / 2 - g.getFontMetrics(g.getFont()).stringWidth(NO_SAMPLES) / 2, g.getClipBounds().height / 2);
            return true;
        }
        return false;
    }

    private void getMinMaxDataValues() {
        this.maxXVal = 0L;
        this.maxYVal = 0.0;
        this.minXVal = Long.MAX_VALUE;
        this.minYVal = Double.MAX_VALUE;
        Iterator<Map.Entry<String, AbstractGraphRow>> it = this.rows.entrySet().iterator();
        AbstractGraphRow rowValue = null;
        int barValue = 0;
        while (it.hasNext()) {
            double[] rowMinMaxY;
            Map.Entry<String, AbstractGraphRow> row = it.next();
            rowValue = row.getValue();
            rowValue.setExcludeOutOfRangeValues(this.chartSettings.isPreventXAxisOverScaling());
            if (!rowValue.isDrawOnChart()) continue;
            if (rowValue.getMaxX() > this.maxXVal) {
                this.maxXVal = rowValue.getMaxX();
            }
            if (rowValue.getMinX() < this.minXVal) {
                this.minXVal = rowValue.getMinX();
            }
            if ((rowMinMaxY = rowValue.getMinMaxY(this.chartSettings.getMaxPointPerRow()))[1] > this.maxYVal) {
                this.maxYVal = rowMinMaxY[1];
            }
            if (rowMinMaxY[0] < this.minYVal) {
                double d = this.minYVal = rowMinMaxY[0] >= 0.0 ? rowMinMaxY[0] : 0.0;
            }
            if (!rowValue.isDrawBar()) continue;
            barValue = rowValue.getGranulationValue();
        }
        if (barValue > 0) {
            this.maxXVal += (long)barValue;
            double barPerSquare = (double)(this.maxXVal - this.minXVal) / (double)(barValue * 10);
            double step = Math.floor(barPerSquare) + 1.0;
            this.maxXVal = (long)((double)this.minXVal + step * (double)barValue * 10.0);
        }
        if (this.forcedMinX >= 0L) {
            this.minXVal = this.forcedMinX;
        }
        if (this.maxXVal == 0L || this.maxYVal == 0.0 || this.minXVal == Long.MAX_VALUE || this.minYVal == Double.MAX_VALUE) {
            this.minYVal = 0.0;
            this.maxYVal = 10.0;
            if (rowValue != null) {
                this.maxXVal = rowValue.getMaxX();
                this.minXVal = rowValue.getMinX();
            }
        } else if (this.chartSettings.isConfigOptimizeYAxis()) {
            this.computeChartSteps();
        } else {
            this.minYVal = 0.0;
        }
        if (this.chartSettings.getForcedMaxY() > 0L) {
            this.maxYVal = Math.max((double)this.chartSettings.getForcedMaxY(), this.minYVal + 1.0);
        }
    }

    private void computeChartSteps() {
        if (this.chartType == 0) {
            this.minYVal = 0.0;
            this.maxYVal = 100.0;
            return;
        }
        if (this.maxYVal - this.minYVal < 0.1) {
            this.maxYVal = this.minYVal + 1.0;
        }
        double step = (this.maxYVal - this.minYVal) / 10.0;
        int pow = -1;
        double factor = -1.0;
        boolean found = false;
        block0: while (!found) {
            ++pow;
            for (double f = 0.0; f < 10.0; f += 1.0) {
                double testStep = Math.pow(10.0, pow) * f;
                if (!(testStep >= step)) continue;
                factor = f;
                found = true;
                continue block0;
            }
        }
        double foundStep = Math.pow(10.0, pow) * factor;
        this.minYVal -= this.minYVal % foundStep;
        if (this.minYVal + foundStep * 10.0 < this.maxYVal) {
            foundStep = Math.pow(10.0, pow) * (factor + (pow > 0 ? 0.5 : 1.0));
        }
        double trim = 10.0;
        while (this.minYVal - this.minYVal % trim + foundStep * 10.0 >= this.maxYVal && this.minYVal > 0.0) {
            this.minYVal -= this.minYVal % trim;
            trim *= 10.0;
        }
        this.maxYVal = this.minYVal + foundStep * 10.0;
    }

    private void setDefaultDimensions(Graphics g) {
        this.chartRect.setBounds(5, 5, g.getClipBounds().width - 10, g.getClipBounds().height - 10);
        this.legendRect.setBounds(zeroRect);
        this.xAxisRect.setBounds(zeroRect);
        this.yAxisRect.setBounds(zeroRect);
    }

    private int getYLabelsMaxWidth(FontMetrics fm) {
        int ret = 0;
        for (int i = 0; i <= 10; ++i) {
            this.yAxisLabelRenderer.setValue((Object)((this.minYVal * 10.0 + (double)i * (this.maxYVal - this.minYVal)) / 10.0));
            int current = fm.stringWidth(this.yAxisLabelRenderer.getText());
            if (current <= ret) continue;
            ret = current;
        }
        return ret;
    }

    private void calculateYAxisDimensions(Graphics g) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int axisWidth = this.getYLabelsMaxWidth(fm) + 15 + fm.getHeight();
        this.yAxisRect.setBounds(this.chartRect.x, this.chartRect.y, axisWidth, this.chartRect.height);
        if (!this.isPreview) {
            this.chartRect.setBounds(this.chartRect.x + axisWidth, this.chartRect.y, this.chartRect.width - axisWidth, this.chartRect.height);
        } else {
            this.chartRect.setBounds(this.chartRect.x + 4, this.chartRect.y, this.chartRect.width, this.chartRect.height);
        }
    }

    private void calculateXAxisDimensions(Graphics g) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int axisHeight = !this.isPreview ? 2 * fm.getHeight() + 5 : 5;
        this.xAxisLabelRenderer.setValue((Object)this.maxXVal);
        int axisEndSpace = fm.stringWidth(this.xAxisLabelRenderer.getText()) / 2;
        this.xAxisRect.setBounds(this.chartRect.x, this.chartRect.y + this.chartRect.height - axisHeight, this.chartRect.width, axisHeight);
        if (!this.isPreview) {
            this.chartRect.setBounds(this.chartRect.x, this.chartRect.y, this.chartRect.width - axisEndSpace, this.chartRect.height - axisHeight);
        } else {
            this.chartRect.setBounds(this.chartRect.x, this.chartRect.y, this.chartRect.width - 8, this.chartRect.height - 5);
        }
        this.yAxisRect.setBounds(this.yAxisRect.x, this.yAxisRect.y, this.yAxisRect.width, this.chartRect.height);
    }

    public void invalidateCache() {
        this.cacheValid = false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int witdh = this.getWidth();
        int height = this.getHeight();
        if (cacheHeight != height || cacheWitdh != witdh || this.gpcId != cacheOwner) {
            this.cacheValid = false;
        }
        if (!this.cacheValid) {
            if (cache == null || cacheHeight != height || cacheWitdh != witdh) {
                cache = new BufferedImage(witdh, height, 2);
            }
            Graphics2D g2d = cache.createGraphics();
            g2d.setClip(0, 0, witdh, height);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawPanel(g2d);
            this.cacheValid = true;
            cacheHeight = height;
            cacheWitdh = witdh;
            cacheOwner = this.gpcId;
        }
        g.drawImage(cache, 0, 0, this);
    }

    private void drawPanel(Graphics2D g) {
        this.drawPanel(g, true);
    }

    private void drawPanel(Graphics2D g, boolean drawHoverInfo) {
        g.setColor(Color.white);
        if (this.chartSettings.isDrawGradient()) {
            GradientPaint gdp = new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, g.getClipBounds().height, gradientColor);
            g.setPaint(gdp);
        }
        g.fillRect(0, 0, g.getClipBounds().width, g.getClipBounds().height);
        this.paintAd(g);
        if (this.drawMessages(g)) {
            return;
        }
        this.setDefaultDimensions(g);
        this.getMinMaxDataValues();
        this.autoZoom_orig();
        this.paintLegend(g);
        this.calculateYAxisDimensions(g);
        this.calculateXAxisDimensions(g);
        this.paintYAxis(g);
        this.paintXAxis(g);
        this.paintChart(g);
        if (drawHoverInfo) {
            this.showHoverInfo();
        }
    }

    private String getNiceNumber(int nb) {
        this.nbFormatter.setValue(nb);
        return this.nbFormatter.getText();
    }

    private void paintLegend(Graphics g) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int rectH = fm.getHeight();
        Iterator<Map.Entry<String, AbstractGraphRow>> it = this.rows.entrySet().iterator();
        int currentX = this.chartRect.x;
        int currentY = this.chartRect.y;
        int legendHeight = it.hasNext() ? rectH + 5 : 0;
        ColorsDispatcher colors = null;
        if (this.reSetColors) {
            colors = ColorsDispatcherFactory.getColorsDispatcher();
        }
        while (it.hasNext()) {
            boolean isBarChart;
            double zoomFactor;
            Color color;
            Map.Entry<String, AbstractGraphRow> row = it.next();
            Color color2 = color = row.getValue().getColor() != null ? row.getValue().getColor() : colors.getNextColor();
            if (!row.getValue().isShowInLegend() || !row.getValue().isDrawOnChart()) continue;
            String rowLabel = row.getKey();
            if (this.chartSettings.isExpendRows() && this.rowsZoomFactor.get(row.getKey()) != null && (zoomFactor = this.rowsZoomFactor.get(row.getKey()).doubleValue()) != 1.0) {
                if (zoomFactor > 1.0) {
                    int iZoomFactor = (int)zoomFactor;
                    rowLabel = rowLabel + " (x" + this.getNiceNumber(iZoomFactor) + ")";
                } else {
                    rowLabel = rowLabel + " (x" + zoomFactor + ")";
                }
            }
            if (currentX + rectH + 2 + fm.stringWidth(rowLabel) > g.getClipBounds().width) {
                currentY += rectH + 2;
                legendHeight += rectH + 2;
                currentX = this.chartRect.x;
            }
            g.setColor(color);
            Composite oldComposite = null;
            boolean bl = isBarChart = row.getValue().isDrawBar() && this.chartSettings.getChartType() == 0 || this.chartSettings.getChartType() == 2;
            if (isBarChart) {
                oldComposite = ((Graphics2D)g).getComposite();
                ((Graphics2D)g).setComposite(this.chartSettings.getBarComposite());
            }
            Rectangle r = new Rectangle(currentX + 3 + 1, currentY + 3 + 1, rectH - 6, rectH - 6);
            ((Graphics2D)g).fill(r);
            row.getValue().setLegendColorBox(r);
            if (isBarChart) {
                ((Graphics2D)g).setComposite(oldComposite);
            }
            g.setColor(color.darker());
            g.drawRect(currentX + 3 + 1, currentY + 3 + 1, rectH - 6, rectH - 6);
            g.setColor(Color.BLACK);
            g.drawString(rowLabel, currentX += rectH + 2, (int)((double)currentY + (double)rectH * 0.9));
            currentX += fm.stringWidth(rowLabel) + 5;
        }
        this.legendRect.setBounds(this.chartRect.x, this.chartRect.y, this.chartRect.width, legendHeight);
        this.chartRect.setBounds(this.chartRect.x, this.chartRect.y + legendHeight + 5, this.chartRect.width, this.chartRect.height - legendHeight - 5);
    }

    private void paintYAxis(Graphics g) {
        int gridLineY;
        int n;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int shift = 0;
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        g.setColor(axisColor);
        for (n = 0; n <= 10; ++n) {
            gridLineY = this.chartRect.y + (int)((double)(10 - n) * (double)this.chartRect.height / 10.0);
            g.drawLine(this.chartRect.x - 3, gridLineY, this.chartRect.x + 3, gridLineY);
        }
        for (n = 0; n <= 10; ++n) {
            if (n != 0) {
                ((Graphics2D)g).setStroke(this.chartSettings.getDashStroke());
                shift = 7;
            }
            gridLineY = this.chartRect.y + (int)((double)(10 - n) * (double)this.chartRect.height / 10.0);
            g.setColor(axisColor);
            g.drawLine(this.chartRect.x + shift, gridLineY, this.chartRect.x + this.chartRect.width, gridLineY);
            g.setColor(Color.black);
            if (this.isPreview) continue;
            this.yAxisLabelRenderer.setValue((Object)((this.minYVal * 10.0 + (double)n * (this.maxYVal - this.minYVal)) / 10.0));
            String valueLabel = this.yAxisLabelRenderer.getText();
            int labelXPos = this.yAxisRect.x + this.yAxisRect.width - fm.stringWidth(valueLabel) - 5 - 2;
            g.drawString(valueLabel, labelXPos, gridLineY + fm.getAscent() / 2);
        }
        if (!this.isPreview) {
            Font oldFont = g.getFont();
            g.setFont(g.getFont().deriveFont(2));
            AffineTransform fontAT = new AffineTransform();
            int delta = g.getFontMetrics(g.getFont()).stringWidth(this.yAxisLabel);
            fontAT.rotate(-1.5707963267948966);
            g.setFont(g.getFont().deriveFont(fontAT));
            g.drawString(this.yAxisLabel, this.yAxisRect.x + 15, this.yAxisRect.y + this.yAxisRect.height / 2 + delta / 2);
            g.setFont(oldFont);
        }
        ((Graphics2D)g).setStroke(oldStroke);
    }

    private void paintXAxis(Graphics g) {
        int gridLineX;
        int n;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int shift = 0;
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        g.setColor(axisColor);
        for (n = 0; n <= 10; ++n) {
            gridLineX = this.chartRect.x + (int)((double)n * ((double)this.chartRect.width / 10.0));
            g.drawLine(gridLineX, this.chartRect.y + this.chartRect.height - 3, gridLineX, this.chartRect.y + this.chartRect.height + 3);
        }
        for (n = 0; n <= 10; ++n) {
            if (n != 0) {
                ((Graphics2D)g).setStroke(this.chartSettings.getDashStroke());
                shift = 7;
            }
            gridLineX = this.chartRect.x + (int)((double)n * ((double)this.chartRect.width / 10.0));
            g.setColor(axisColor);
            g.drawLine(gridLineX, this.chartRect.y + this.chartRect.height - shift, gridLineX, this.chartRect.y);
            g.setColor(Color.black);
            double labelValue = (double)this.minXVal + (double)n * (double)(this.maxXVal - this.minXVal) / 10.0;
            if (this.maxXVal - this.minXVal < 20L && this.minXVal != this.maxXVal) {
                this.xAxisLabelRenderer.setValue((Object)labelValue);
            } else {
                this.xAxisLabelRenderer.setValue((Object)((long)labelValue));
            }
            String valueLabel = this.xAxisLabelRenderer.getText();
            int labelXPos = gridLineX - fm.stringWidth(valueLabel) / 2;
            g.drawString(valueLabel, labelXPos, this.xAxisRect.y + fm.getAscent() + 5);
        }
        Font oldFont = g.getFont();
        g.setFont(g.getFont().deriveFont(2));
        g.drawString(this.getXAxisLabel(), this.chartRect.x + this.chartRect.width / 2 - g.getFontMetrics(g.getFont()).stringWidth(this.getXAxisLabel()) / 2, this.xAxisRect.y + 2 * fm.getAscent() + 5 + 3);
        g.setFont(oldFont);
        ((Graphics2D)g).setStroke(oldStroke);
        if (this.chartSettings.isDrawCurrentX()) {
            gridLineX = this.chartRect.x + (int)((double)(this.currentXVal - this.minXVal) * (double)this.chartRect.width / (double)(this.maxXVal - this.minXVal));
            g.setColor(Color.GRAY);
            g.drawLine(gridLineX, this.chartRect.y, gridLineX, this.chartRect.y + this.chartRect.height);
            g.setColor(Color.black);
        }
    }

    private void paintChart(Graphics g) {
        g.setColor(Color.yellow);
        ColorsDispatcher dispatcher = null;
        if (this.reSetColors) {
            dispatcher = ColorsDispatcherFactory.getColorsDispatcher();
        }
        this.limitPointFactor = 1;
        if (this.chartSettings.getMaxPointPerRow() > 0) {
            for (Map.Entry<String, AbstractGraphRow> row : this.rows.entrySet()) {
                int rowFactor = (int)Math.floor((double)row.getValue().size() / (double)this.chartSettings.getMaxPointPerRow()) + 1;
                if (rowFactor <= this.limitPointFactor) continue;
                this.limitPointFactor = rowFactor;
            }
        }
        Iterator<Map.Entry<String, AbstractGraphRow>> it = this.rows.entrySet().iterator();
        this.paintRows(g, dispatcher, it, false);
        it = this.rows.entrySet().iterator();
        this.paintRows(g, dispatcher, it, true);
    }

    private void paintRows(Graphics g, ColorsDispatcher dispatcher, Iterator<Map.Entry<String, AbstractGraphRow>> it, boolean rowsWithLabel) {
        while (it.hasNext()) {
            Map.Entry<String, AbstractGraphRow> row = it.next();
            if (!row.getValue().isDrawOnChart() || row.getValue().isDrawValueLabel() != rowsWithLabel) continue;
            Color color = row.getValue().getColor() != null ? row.getValue().getColor() : dispatcher.getNextColor();
            this.paintRow(g, row.getValue(), row.getKey(), color);
        }
    }

    private void paintRow(Graphics g, AbstractGraphRow row, String rowLabel, Color color) {
        if (row.isDrawLine() && this.chartSettings.getChartType() == 0 || this.chartSettings.getChartType() == 1) {
            this.currentPlotter = this.lineRowPlotter;
        } else if (row.isDrawBar() && this.chartSettings.getChartType() == 0 || this.chartSettings.getChartType() == 2) {
            this.currentPlotter = this.barRowPlotter;
        } else if (row.isDrawSpline() && this.chartSettings.getChartType() == 0 || this.chartSettings.getChartType() == 3) {
            this.currentPlotter = this.cSplineRowPlotter;
        }
        if (this.currentPlotter != null) {
            double zoomFactor = 1.0;
            if (this.chartSettings.isExpendRows() && this.rowsZoomFactor.get(rowLabel) != null) {
                zoomFactor = this.rowsZoomFactor.get(rowLabel);
            }
            this.currentPlotter.setBoundsValues(this.chartRect, this.minXVal, this.maxXVal, this.minYVal, this.maxYVal);
            this.currentPlotter.paintRow((Graphics2D)g, row, color, zoomFactor, this.limitPointFactor);
        }
    }

    public void setRows(AbstractMap<String, AbstractGraphRow> aRows) {
        this.rows = aRows;
    }

    public void setyAxisLabelRenderer(NumberRenderer yAxisLabelRenderer) {
        this.yAxisLabelRenderer = yAxisLabelRenderer;
    }

    public void setxAxisLabelRenderer(NumberRenderer xAxisLabelRenderer) {
        this.xAxisLabelRenderer = xAxisLabelRenderer;
    }

    public void setCurrentX(long currentX) {
        this.currentXVal = currentX;
    }

    public void setForcedMinX(long minX) {
        this.forcedMinX = minX;
    }

    private void paintAd(Graphics2D g) {
        Font oldFont = g.getFont();
        g.setFont(g.getFont().deriveFont(10.0f));
        g.setColor(axisColor);
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g.drawString(AD_TEXT, g.getClipBounds().width - g.getFontMetrics().stringWidth(AD_TEXT) - 5, g.getFontMetrics().getHeight() - 5 + 1);
        g.setComposite(oldComposite);
        g.setFont(oldFont);
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
    }

    public void setErrorMessage(String msg) {
        if (msg != null && msg.trim().length() > 0) {
            this.errorMessage = msg;
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private Image getImage() {
        return this.getBufferedImage(this.getWidth(), this.getHeight());
    }

    private BufferedImage getBufferedImage(int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setClip(0, 0, w, h);
        this.drawPanel(g2, false);
        return image;
    }

    private void registerPopup(boolean allowCsvExport) {
        this.setComponentPopupMenu(this.popup);
        JMenuItem itemCopy = new JMenuItem("Copy Image to Clipboard");
        itemCopy.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/img/copy.png")));
        JMenuItem itemSave = new JMenuItem("Save Image as...");
        itemSave.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/img/save.png")));
        JMenuItem itemExport = new JMenuItem("Export to CSV...");
        itemExport.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/img/export.png")));
        itemCopy.addActionListener(new CopyAction());
        itemSave.addActionListener(new SaveAction());
        itemExport.addActionListener(new CsvExportAction());
        this.popup.add(itemCopy);
        this.popup.add(itemSave);
        if (allowCsvExport) {
            this.popup.addSeparator();
            this.popup.add(itemExport);
        }
    }

    private void registerHoverInfo() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (!GraphPanelChart.this.isPreview && evt.getButton() == 1) {
                    GraphPanelChart.this.forceHoverPosition = true;
                    GraphPanelChart.this.addMouseMotionListener(GraphPanelChart.this.motionListener);
                    GraphPanelChart.this.chartMouseMoved(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (!GraphPanelChart.this.isPreview) {
                    GraphPanelChart.this.hideHoverInfo();
                    GraphPanelChart.this.removeMouseMotionListener(GraphPanelChart.this.motionListener);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                if (!GraphPanelChart.this.isPreview) {
                    GraphPanelChart.this.hideHoverInfo();
                }
            }
        });
    }

    private void hideHoverInfo() {
        this.hoverWindow.setVisible(false);
        this.xHoverInfo = -1;
        this.yHoverInfo = -1;
    }

    private synchronized void showHoverInfo() {
        if (this.isPreview || this.chartRect.width == 0 || this.chartRect.height == 0 || this.xHoverInfo == -1 || this.yHoverInfo == -1) {
            return;
        }
        long realX = this.minXVal + (this.maxXVal - this.minXVal) * (long)(this.xHoverInfo - this.chartRect.x) / (long)this.chartRect.width;
        double realY = this.minYVal + (this.maxYVal - this.minYVal) * (double)(this.chartRect.height - this.yHoverInfo + this.chartRect.y) / (double)this.chartRect.height;
        this.xAxisLabelRenderer.setValue((Object)realX);
        this.yAxisLabelRenderer.setValue((Object)realY);
        String hoverInfo = "(" + this.xAxisLabelRenderer.getText() + " ; " + this.yAxisLabelRenderer.getText() + ")";
        this.hoverLabel.setText(hoverInfo);
        int labelWidth = this.hoverLabel.getPreferredSize().width + 5;
        int labelHeight = this.hoverLabel.getPreferredSize().height;
        if (this.hoverWindow.getWidth() < labelWidth || this.hoverWindow.getHeight() < labelHeight) {
            this.hoverWindow.setSize(labelWidth, labelHeight);
        }
        Point mousePos = MouseInfo.getPointerInfo().getLocation();
        int hoverWindowX = mousePos.x + 20;
        int hoverWindowY = mousePos.y + 20;
        double deltaX = Math.abs(this.hoverWindow.getLocation().getX() - (double)hoverWindowX);
        double deltaY = Math.abs(this.hoverWindow.getLocation().getY() - (double)hoverWindowY);
        if (this.forceHoverPosition || deltaX >= 20.0 || deltaY >= 20.0) {
            int correctedX = Math.min(hoverWindowX, Toolkit.getDefaultToolkit().getScreenSize().width - this.hoverWindow.getSize().width);
            this.hoverWindow.setLocation(correctedX, hoverWindowY);
            this.forceHoverPosition = false;
        }
    }

    private void chartMouseMoved(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (x >= this.chartRect.x && x <= this.chartRect.x + this.chartRect.width && y >= this.chartRect.y && y <= this.chartRect.y + this.chartRect.height) {
            this.xHoverInfo = x;
            this.yHoverInfo = y;
            this.showHoverInfo();
            this.hoverWindow.setVisible(true);
        } else {
            this.hoverWindow.setVisible(false);
            this.xHoverInfo = -1;
            this.yHoverInfo = -1;
        }
    }

    public void setUseRelativeTime(boolean selected) {
        this.chartSettings.setUseRelativeTime(selected);
        if (selected) {
            this.setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss", this.testStartTime));
        } else {
            this.setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        }
    }

    public void saveGraphToPNG(File file, int w, int h) throws IOException {
        log.info("Saving PNG to " + file.getAbsolutePath());
        FileOutputStream fos = new FileOutputStream(file);
        ImageIO.write((RenderedImage)this.getBufferedImage(w, h), "png", fos);
        fos.flush();
        fos.close();
    }

    public void saveGraphToCSV(File file) throws IOException {
        log.info("Saving CSV to " + file.getAbsolutePath());
        GraphModelToCsvExporter exporter = new GraphModelToCsvExporter(this.rows, file, this.chartSettings.getConfigCsvSeparator(), this.xAxisLabel, this.xAxisLabelRenderer, this.chartSettings.getHideNonRepValLimit());
        exporter.writeCsvFile();
    }

    static {
        cacheOwner = -1;
        uidGenerator = 0;
        log = LoggerFactory.getLogger(GraphPanelChart.class);
        zeroRect = new Rectangle();
        gradientColor = new Color(229, 236, 246);
        axisColor = new Color(189, 196, 206);
        savePath = null;
    }

    private class HoverMotionListener
    extends MouseMotionAdapter
    implements Serializable {
        private HoverMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            GraphPanelChart.this.chartMouseMoved(evt);
        }
    }

    private class CsvExportAction
    implements ActionListener {
        private CsvExportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = savePath != null ? new JFileChooser(new File(savePath)) : new JFileChooser(new File("."));
            chooser.setFileFilter(new FileNameExtensionFilter("CSV Files", "csv"));
            int returnVal = chooser.showSaveDialog(GraphPanelChart.this);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                if (!file.getAbsolutePath().toUpperCase().endsWith(".CSV")) {
                    file = new File(file.getAbsolutePath() + ".csv");
                }
                savePath = file.getParent();
                boolean doSave = true;
                if (file.exists()) {
                    int choice = JOptionPane.showConfirmDialog(GraphPanelChart.this, "Do you want to overwrite " + file.getAbsolutePath() + "?", "Export to CSV File", 0, 3);
                    boolean bl = doSave = choice == 0;
                }
                if (doSave) {
                    try {
                        GraphPanelChart.this.saveGraphToCSV(file);
                    }
                    catch (IOException ex) {
                        JOptionPane.showConfirmDialog(GraphPanelChart.this, "Impossible to write the CSV file:\n" + ex.getMessage(), "Export to CSV File", -1, 0);
                    }
                }
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = savePath != null ? new JFileChooser(new File(savePath)) : new JFileChooser(new File("."));
            chooser.setFileFilter(new FileNameExtensionFilter("PNG Images", "png"));
            int returnVal = chooser.showSaveDialog(GraphPanelChart.this);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                if (!file.getAbsolutePath().toUpperCase().endsWith(".PNG")) {
                    file = new File(file.getAbsolutePath() + ".png");
                }
                savePath = file.getParent();
                boolean doSave = true;
                if (file.exists()) {
                    int choice = JOptionPane.showConfirmDialog(GraphPanelChart.this, "Do you want to overwrite " + file.getAbsolutePath() + "?", "Save Image as", 0, 3);
                    boolean bl = doSave = choice == 0;
                }
                if (doSave) {
                    try {
                        GraphPanelChart.this.saveGraphToPNG(file, GraphPanelChart.this.getWidth(), GraphPanelChart.this.getHeight());
                    }
                    catch (IOException ex) {
                        JOptionPane.showConfirmDialog(GraphPanelChart.this, "Impossible to write the image to the file:\n" + ex.getMessage(), "Save Image as", -1, 0);
                    }
                }
            }
        }
    }

    private class CopyAction
    implements ActionListener {
        private CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = GraphPanelChart.this.getToolkit().getSystemClipboard();
            Transferable transferable = new Transferable(){

                @Override
                public Object getTransferData(DataFlavor flavor) {
                    if (this.isDataFlavorSupported(flavor)) {
                        return GraphPanelChart.this.getImage();
                    }
                    return null;
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.imageFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return DataFlavor.imageFlavor.equals(flavor);
                }
            };
            clipboard.setContents(transferable, GraphPanelChart.this);
        }
    }
}

