/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.internal.Nullable;
import brave.messaging.ProducerRequest;
import brave.propagation.Propagation;
import brave.spring.rabbit.SpringRabbitPropagation;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

final class MessageProducerRequest
extends ProducerRequest {
    static final Propagation.Getter<MessageProducerRequest, String> GETTER = new Propagation.Getter<MessageProducerRequest, String>(){

        public String get(MessageProducerRequest request, String name) {
            return request.getHeader(name);
        }

        public String toString() {
            return "MessageProducerRequest::getHeader";
        }
    };
    static final Propagation.Setter<MessageProducerRequest, String> SETTER = new Propagation.Setter<MessageProducerRequest, String>(){

        public void put(MessageProducerRequest request, String name, String value) {
            request.setHeader(name, value);
        }

        public String toString() {
            return "MessageProducerRequest::setHeader";
        }
    };
    final Message delegate;

    MessageProducerRequest(Message delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public Span.Kind spanKind() {
        return Span.Kind.PRODUCER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "send";
    }

    public String channelKind() {
        return "queue";
    }

    public String channelName() {
        MessageProperties properties = this.delegate.getMessageProperties();
        return properties != null ? properties.getConsumerQueue() : null;
    }

    @Nullable
    String getHeader(String name) {
        MessageProperties properties = this.delegate.getMessageProperties();
        return properties != null ? SpringRabbitPropagation.GETTER.get((Object)properties, (Object)name) : null;
    }

    void setHeader(String name, String value) {
        MessageProperties properties = this.delegate.getMessageProperties();
        if (properties == null) {
            return;
        }
        SpringRabbitPropagation.SETTER.put((Object)properties, (Object)name, value);
    }
}

