/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.internal.Nullable;
import brave.kafka.clients.KafkaPropagation;
import brave.messaging.ConsumerRequest;
import org.apache.kafka.clients.consumer.ConsumerRecord;

final class KafkaConsumerRequest
extends ConsumerRequest {
    final ConsumerRecord<?, ?> delegate;

    KafkaConsumerRequest(ConsumerRecord<?, ?> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public Span.Kind spanKind() {
        return Span.Kind.CONSUMER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "receive";
    }

    public String channelKind() {
        return "topic";
    }

    public String channelName() {
        return this.delegate.topic();
    }

    @Nullable
    String getHeader(String key) {
        return KafkaPropagation.GETTER.get((Object)this.delegate.headers(), (Object)key);
    }

    void setHeader(String key, String value) {
        KafkaPropagation.SETTER.put((Object)this.delegate.headers(), (Object)key, value);
    }
}

