/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.internal.Throwables;
import brave.jms.JmsTracing;
import brave.propagation.Propagation;
import javax.jms.Message;

final class MessagePropagation {
    static final Propagation.Getter<Message, String> GETTER = new Propagation.Getter<Message, String>(){

        public String get(Message message, String name) {
            try {
                return message.getStringProperty(name);
            }
            catch (Throwable t) {
                Throwables.propagateIfFatal((Throwable)t);
                JmsTracing.log(t, "error getting property {0} from message {1}", name, message);
                return null;
            }
        }

        public String toString() {
            return "Message::getStringProperty";
        }
    };
    static final Propagation.Setter<Message, String> SETTER = new Propagation.Setter<Message, String>(){

        public void put(Message message, String name, String value) {
            try {
                message.setStringProperty(name, value);
            }
            catch (Throwable t) {
                Throwables.propagateIfFatal((Throwable)t);
                JmsTracing.log(t, "error setting property {0} on message {1}", name, message);
            }
        }

        public String toString() {
            return "Message::setStringProperty";
        }
    };

    MessagePropagation() {
    }
}

