/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.SortOrder;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;

public class SortArgument
implements Argument {
    private final String[] path;
    private final SortOrder order;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])this.path)) {
            arg.add(String.format("path:%s", Serializer.arrayWithQuotes(this.path)));
        }
        if (this.order != null) {
            arg.add(String.format("order:%s", new Object[]{this.order}));
        }
        return String.format("{%s}", String.join((CharSequence)" ", arg));
    }

    SortArgument(String[] path, SortOrder order) {
        this.path = path;
        this.order = order;
    }

    public static SortArgumentBuilder builder() {
        return new SortArgumentBuilder();
    }

    public String[] getPath() {
        return this.path;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public String toString() {
        return "SortArgument(path=" + Arrays.deepToString(this.getPath()) + ", order=" + (Object)((Object)this.getOrder()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortArgument)) {
            return false;
        }
        SortArgument other = (SortArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPath(), other.getPath())) {
            return false;
        }
        SortOrder this$order = this.getOrder();
        SortOrder other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !((Object)((Object)this$order)).equals((Object)other$order));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getPath());
        SortOrder $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)((Object)$order)).hashCode());
        return result;
    }

    public static class SortArgumentBuilder {
        private String[] path;
        private SortOrder order;

        SortArgumentBuilder() {
        }

        public SortArgumentBuilder path(String[] path) {
            this.path = path;
            return this;
        }

        public SortArgumentBuilder order(SortOrder order) {
            this.order = order;
            return this;
        }

        public SortArgument build() {
            return new SortArgument(this.path, this.order);
        }

        public String toString() {
            return "SortArgument.SortArgumentBuilder(path=" + Arrays.deepToString(this.path) + ", order=" + (Object)((Object)this.order) + ")";
        }
    }
}

