/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;

public class NearVectorArgument
implements Argument {
    private final Float[] vector;
    private final Float certainty;
    private final Float distance;
    private final String[] targetVectors;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (this.vector != null) {
            arg.add(String.format("vector:%s", Serializer.array(this.vector)));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance:%s", this.distance));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        return String.format("nearVector:{%s}", String.join((CharSequence)" ", arg));
    }

    NearVectorArgument(Float[] vector, Float certainty, Float distance, String[] targetVectors) {
        this.vector = vector;
        this.certainty = certainty;
        this.distance = distance;
        this.targetVectors = targetVectors;
    }

    public static NearVectorArgumentBuilder builder() {
        return new NearVectorArgumentBuilder();
    }

    public Float[] getVector() {
        return this.vector;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    public String toString() {
        return "NearVectorArgument(vector=" + Arrays.deepToString(this.getVector()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearVectorArgument)) {
            return false;
        }
        NearVectorArgument other = (NearVectorArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVector(), other.getVector())) {
            return false;
        }
        return Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NearVectorArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getVector());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        return result;
    }

    public static class NearVectorArgumentBuilder {
        private Float[] vector;
        private Float certainty;
        private Float distance;
        private String[] targetVectors;

        NearVectorArgumentBuilder() {
        }

        public NearVectorArgumentBuilder vector(Float[] vector) {
            this.vector = vector;
            return this;
        }

        public NearVectorArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearVectorArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearVectorArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        public NearVectorArgument build() {
            return new NearVectorArgument(this.vector, this.certainty, this.distance, this.targetVectors);
        }

        public String toString() {
            return "NearVectorArgument.NearVectorArgumentBuilder(vector=" + Arrays.deepToString(this.vector) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ")";
        }
    }
}

