/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.NearMediaArgumentHelper;
import java.io.File;
import java.util.Arrays;

public class NearThermalArgument
implements Argument {
    private final String thermal;
    private final File thermalFile;
    private final Float certainty;
    private final Float distance;
    private final String[] targetVectors;

    @Override
    public String build() {
        return NearMediaArgumentHelper.builder().certainty(this.certainty).distance(this.distance).targetVectors(this.targetVectors).data(this.thermal).dataFile(this.thermalFile).mediaField("thermal").mediaName("nearThermal").build().build();
    }

    NearThermalArgument(String thermal, File thermalFile, Float certainty, Float distance, String[] targetVectors) {
        this.thermal = thermal;
        this.thermalFile = thermalFile;
        this.certainty = certainty;
        this.distance = distance;
        this.targetVectors = targetVectors;
    }

    public static NearThermalArgumentBuilder builder() {
        return new NearThermalArgumentBuilder();
    }

    public String getThermal() {
        return this.thermal;
    }

    public File getThermalFile() {
        return this.thermalFile;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    public String toString() {
        return "NearThermalArgument(thermal=" + this.getThermal() + ", thermalFile=" + this.getThermalFile() + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearThermalArgument)) {
            return false;
        }
        NearThermalArgument other = (NearThermalArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        String this$thermal = this.getThermal();
        String other$thermal = other.getThermal();
        if (this$thermal == null ? other$thermal != null : !this$thermal.equals(other$thermal)) {
            return false;
        }
        File this$thermalFile = this.getThermalFile();
        File other$thermalFile = other.getThermalFile();
        if (this$thermalFile == null ? other$thermalFile != null : !((Object)this$thermalFile).equals(other$thermalFile)) {
            return false;
        }
        return Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NearThermalArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        String $thermal = this.getThermal();
        result = result * 59 + ($thermal == null ? 43 : $thermal.hashCode());
        File $thermalFile = this.getThermalFile();
        result = result * 59 + ($thermalFile == null ? 43 : ((Object)$thermalFile).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        return result;
    }

    public static class NearThermalArgumentBuilder {
        private String thermal;
        private File thermalFile;
        private Float certainty;
        private Float distance;
        private String[] targetVectors;

        NearThermalArgumentBuilder() {
        }

        public NearThermalArgumentBuilder thermal(String thermal) {
            this.thermal = thermal;
            return this;
        }

        public NearThermalArgumentBuilder thermalFile(File thermalFile) {
            this.thermalFile = thermalFile;
            return this;
        }

        public NearThermalArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearThermalArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearThermalArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        public NearThermalArgument build() {
            return new NearThermalArgument(this.thermal, this.thermalFile, this.certainty, this.distance, this.targetVectors);
        }

        public String toString() {
            return "NearThermalArgument.NearThermalArgumentBuilder(thermal=" + this.thermal + ", thermalFile=" + this.thermalFile + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ")";
        }
    }
}

