/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.data.util;

import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.TriConsumer;
import io.weaviate.client.base.util.UrlEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ObjectsPath {
    private final DbVersionSupport support;

    public ObjectsPath(DbVersionSupport support) {
        this.support = support;
    }

    public String buildCreate(Params params) {
        return this.build(params, this::addQueryConsistencyLevel);
    }

    public String buildDelete(Params params) {
        return this.build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addQueryConsistencyLevel, this::addQueryTenant);
    }

    public String buildUpdate(Params params) {
        return this.build(params, this::addPathClassNameWithDeprecatedCheck, this::addPathId, this::addQueryConsistencyLevel, this::addQueryTenant);
    }

    public String buildCheck(Params params) {
        return this.build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addQueryTenant);
    }

    public String buildGet(Params params) {
        return this.build(params, this::addQueryClassNameWithDeprecatedCheck, this::addQueryAdditionals, this::addQueryLimit, this::addQueryOffset, this::addQueryAfter, this::addQueryTenant);
    }

    public String buildGetOne(Params params) {
        return this.build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addQueryAdditionals, this::addQueryConsistencyLevel, this::addQueryNodeName, this::addQueryTenant);
    }

    @SafeVarargs
    private final String build(Params params, TriConsumer<Params, List<String>, List<String>> ... appenders) {
        Objects.requireNonNull(params);
        ArrayList<String> pathParams = new ArrayList<String>();
        ArrayList queryParams = new ArrayList();
        pathParams.add("/objects");
        Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
        String path = String.join((CharSequence)"/", pathParams);
        if (!queryParams.isEmpty()) {
            return path + "?" + String.join((CharSequence)"&", queryParams);
        }
        return path;
    }

    private void addPathClassNameWithDeprecatedNotSupportedCheck(Params params, List<String> pathParams, List<String> queryParams) {
        if (this.support.supportsClassNameNamespacedEndpoints()) {
            if (StringUtils.isNotBlank((CharSequence)params.className)) {
                pathParams.add(UrlEncoder.encodePathParam(params.className));
            } else {
                this.support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
            }
        } else if (StringUtils.isNotBlank((CharSequence)params.className)) {
            this.support.warnNotSupportedClassNamespacedEndpointsForObjects();
        }
    }

    private void addPathClassNameWithDeprecatedCheck(Params params, List<String> pathParams, List<String> queryParams) {
        if (this.support.supportsClassNameNamespacedEndpoints()) {
            if (StringUtils.isNotBlank((CharSequence)params.className)) {
                pathParams.add(UrlEncoder.encodePathParam(params.className));
            } else {
                this.support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
            }
        }
    }

    private void addPathId(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.id)) {
            pathParams.add(UrlEncoder.encodePathParam(params.id));
        }
    }

    private void addQueryClassNameWithDeprecatedCheck(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isBlank((CharSequence)params.id) && StringUtils.isNotBlank((CharSequence)params.className)) {
            if (this.support.supportsClassNameNamespacedEndpoints()) {
                queryParams.add(UrlEncoder.encodeQueryParam("class", params.className));
            } else {
                this.support.warnNotSupportedClassParameterInEndpointsForObjects();
            }
        }
    }

    private void addQueryAdditionals(Params params, List<String> pathParams, List<String> queryParams) {
        String include;
        if (ObjectUtils.isNotEmpty((Object)params.additional) && StringUtils.isNotBlank((CharSequence)(include = Arrays.stream(params.additional).map(UrlEncoder::encodePathParam).filter(StringUtils::isNotBlank).collect(Collectors.joining(","))))) {
            queryParams.add(String.format("%s=%s", "include", include));
        }
    }

    private void addQueryLimit(Params params, List<String> pathParams, List<String> queryParams) {
        if (params.limit != null) {
            queryParams.add(UrlEncoder.encodeQueryParam("limit", Integer.toString(params.limit)));
        }
    }

    private void addQueryOffset(Params params, List<String> pathParams, List<String> queryParams) {
        if (params.offset != null) {
            queryParams.add(UrlEncoder.encodeQueryParam("offset", Integer.toString(params.offset)));
        }
    }

    private void addQueryAfter(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.after)) {
            queryParams.add(UrlEncoder.encodeQueryParam("after", params.after));
        }
    }

    private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.consistencyLevel)) {
            queryParams.add(UrlEncoder.encodeQueryParam("consistency_level", params.consistencyLevel));
        }
    }

    private void addQueryNodeName(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.nodeName)) {
            queryParams.add(UrlEncoder.encodeQueryParam("node_name", params.nodeName));
        }
    }

    private void addQueryTenant(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.tenant)) {
            queryParams.add(UrlEncoder.encodeQueryParam("tenant", params.tenant));
        }
    }

    public static class Params {
        private final String id;
        private final String className;
        private final Integer limit;
        private final Integer offset;
        private final String after;
        private final String[] additional;
        private final String consistencyLevel;
        private final String nodeName;
        private final String tenant;

        Params(String id, String className, Integer limit, Integer offset, String after, String[] additional, String consistencyLevel, String nodeName, String tenant) {
            this.id = id;
            this.className = className;
            this.limit = limit;
            this.offset = offset;
            this.after = after;
            this.additional = additional;
            this.consistencyLevel = consistencyLevel;
            this.nodeName = nodeName;
            this.tenant = tenant;
        }

        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        public String toString() {
            return "ObjectsPath.Params(id=" + this.id + ", className=" + this.className + ", limit=" + this.limit + ", offset=" + this.offset + ", after=" + this.after + ", additional=" + Arrays.deepToString(this.additional) + ", consistencyLevel=" + this.consistencyLevel + ", nodeName=" + this.nodeName + ", tenant=" + this.tenant + ")";
        }

        public static class ParamsBuilder {
            private String id;
            private String className;
            private Integer limit;
            private Integer offset;
            private String after;
            private String[] additional;
            private String consistencyLevel;
            private String nodeName;
            private String tenant;

            ParamsBuilder() {
            }

            public ParamsBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ParamsBuilder className(String className) {
                this.className = className;
                return this;
            }

            public ParamsBuilder limit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public ParamsBuilder offset(Integer offset) {
                this.offset = offset;
                return this;
            }

            public ParamsBuilder after(String after) {
                this.after = after;
                return this;
            }

            public ParamsBuilder additional(String[] additional) {
                this.additional = additional;
                return this;
            }

            public ParamsBuilder consistencyLevel(String consistencyLevel) {
                this.consistencyLevel = consistencyLevel;
                return this;
            }

            public ParamsBuilder nodeName(String nodeName) {
                this.nodeName = nodeName;
                return this;
            }

            public ParamsBuilder tenant(String tenant) {
                this.tenant = tenant;
                return this;
            }

            public Params build() {
                return new Params(this.id, this.className, this.limit, this.offset, this.after, this.additional, this.consistencyLevel, this.nodeName, this.tenant);
            }

            public String toString() {
                return "ObjectsPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", limit=" + this.limit + ", offset=" + this.offset + ", after=" + this.after + ", additional=" + Arrays.deepToString(this.additional) + ", consistencyLevel=" + this.consistencyLevel + ", nodeName=" + this.nodeName + ", tenant=" + this.tenant + ")";
            }
        }
    }
}

