/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.sstore.AbstractSession;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class SharedDataSessionImpl
extends AbstractSession
implements ClusterSerializable,
Shareable {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    public SharedDataSessionImpl() {
    }

    public SharedDataSessionImpl(VertxContextPRNG random) {
        super(random);
    }

    public SharedDataSessionImpl(VertxContextPRNG random, long timeout, int length) {
        super(random, timeout, length);
    }

    public void writeToBuffer(Buffer buff) {
        byte[] bytes = this.id().getBytes(UTF8);
        buff.appendInt(bytes.length).appendBytes(bytes);
        buff.appendLong(this.timeout());
        buff.appendLong(this.lastAccessed());
        buff.appendInt(this.version());
        this.writeDataToBuffer(buff);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.setId(new String(bytes, UTF8));
        this.setTimeout(buffer.getLong(pos += len));
        this.setLastAccessed(buffer.getLong(pos += 8));
        this.setVersion(buffer.getInt(pos += 8));
        pos += 4;
        pos = this.readDataFromBuffer(pos, buffer);
        return pos;
    }
}

