/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class ServerWebSocketWrapper
implements ServerWebSocket {
    private final ServerWebSocket delegate;
    private final HostAndPort authority;
    private final String scheme;
    private final boolean isSsl;
    private final SocketAddress remoteAddress;

    public ServerWebSocketWrapper(ServerWebSocket delegate, HostAndPort authority, String scheme, boolean isSsl, SocketAddress remoteAddress) {
        this.delegate = delegate;
        this.authority = authority;
        this.scheme = scheme;
        this.isSsl = isSsl;
        this.remoteAddress = remoteAddress;
    }

    public ServerWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Future<Void> write(Buffer data) {
        return this.delegate.write((Object)data);
    }

    public ServerWebSocket handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public ServerWebSocket pause() {
        this.delegate.pause();
        return this;
    }

    public ServerWebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public ServerWebSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.delegate.writeQueueFull();
    }

    public ServerWebSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public String binaryHandlerID() {
        return this.delegate.binaryHandlerID();
    }

    public String textHandlerID() {
        return this.delegate.textHandlerID();
    }

    public String subProtocol() {
        return this.delegate.subProtocol();
    }

    public Short closeStatusCode() {
        return this.delegate.closeStatusCode();
    }

    public String closeReason() {
        return this.delegate.closeReason();
    }

    public MultiMap headers() {
        return this.delegate.headers();
    }

    public Future<Void> writeFrame(WebSocketFrame frame) {
        return this.delegate.writeFrame(frame);
    }

    public Future<Void> writeFinalTextFrame(String text) {
        return this.delegate.writeFinalTextFrame(text);
    }

    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        return this.delegate.writeFinalBinaryFrame(data);
    }

    public Future<Void> writeBinaryMessage(Buffer data) {
        return this.delegate.writeBinaryMessage(data);
    }

    public Future<Void> writeTextMessage(String text) {
        return this.delegate.writeTextMessage(text);
    }

    public Future<Void> writePing(Buffer data) {
        return this.delegate.writePing(data);
    }

    public Future<Void> writePong(Buffer data) {
        return this.delegate.writePong(data);
    }

    public ServerWebSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public WebSocket shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public Future<Void> shutdown(long timeout, TimeUnit unit, short statusCode, @Nullable String reason) {
        return this.delegate.shutdown(timeout, unit, statusCode, reason);
    }

    public ServerWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler(handler);
        return this;
    }

    public ServerWebSocket textMessageHandler(@Nullable Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    public ServerWebSocket binaryMessageHandler(@Nullable Handler<Buffer> handler) {
        this.delegate.binaryMessageHandler(handler);
        return this;
    }

    public ServerWebSocket pongHandler(@Nullable Handler<Buffer> handler) {
        this.delegate.pongHandler(handler);
        return this;
    }

    public Future<Void> end() {
        return this.delegate.end();
    }

    public @Nullable String scheme() {
        return this.scheme;
    }

    public @Nullable HostAndPort authority() {
        return this.authority;
    }

    public String uri() {
        return this.delegate.uri();
    }

    public String path() {
        return this.delegate.path();
    }

    public @Nullable String query() {
        return this.delegate.query();
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public boolean isSsl() {
        return this.isSsl;
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificates();
    }
}

