/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.drda.SqlCode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Decimal {
    public static final int PACKED_DECIMAL = 48;
    private static final int[][] tenRadixMagnitude = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};
    private static byte[][] tenRadixArr = new byte[][]{{1}, {10}, {100}, {3, -24}, {39, 16}, {1, -122, -96}, {15, 66, 64}, {-104, -106, -128}, {5, -11, -31, 0}, {59, -102, -54, 0}, {2, 84, 11, -28, 0}, {23, 72, 118, -24, 0}, {-24, -44, -91, 16, 0}, {9, 24, 78, 114, -96, 0}, {90, -13, 16, 122, 64, 0}, {3, -115, 126, -92, -58, -128, 0}, {35, -122, -14, 111, -63, 0, 0}, {1, 99, 69, 120, 93, -118, 0, 0}, {13, -32, -74, -77, -89, 100, 0, 0}, {-118, -57, 35, 4, -119, -24, 0, 0}, {5, 107, -57, 94, 45, 99, 16, 0, 0}, {54, 53, -55, -83, -59, -34, -96, 0, 0}, {2, 30, 25, -32, -55, -70, -78, 64, 0, 0}, {21, 45, 2, -57, -31, 74, -10, -128, 0, 0}, {-45, -62, 27, -50, -52, -19, -95, 0, 0, 0}, {8, 69, -107, 22, 20, 1, 72, 74, 0, 0, 0}, {82, -73, -46, -36, -56, 12, -46, -28, 0, 0, 0}, {3, 59, 46, 60, -97, -48, -128, 60, -24, 0, 0, 0}, {32, 79, -50, 94, 62, 37, 2, 97, 16, 0, 0, 0}, {1, 67, 30, 15, -82, 109, 114, 23, -54, -96, 0, 0, 0}, {12, -97, 44, -100, -48, 70, 116, -19, -22, 64, 0, 0, 0}, {126, 55, -66, 32, 34, -64, -111, 75, 38, -128, 0, 0, 0}};

    private Decimal() {
    }

    private static final int packedNybblesToInt(ByteBuf buffer, int offset, int startNybble, int numberOfNybbles) {
        int value = 0;
        int i = startNybble / 2;
        if (startNybble % 2 != 0) {
            value += buffer.getByte(offset + i) & 0xF;
            ++i;
        }
        int endNybble = startNybble + numberOfNybbles - 1;
        while (i < (endNybble + 1) / 2) {
            value = value * 10 + ((buffer.getByte(offset + i) & 0xF0) >>> 4);
            value = value * 10 + (buffer.getByte(offset + i) & 0xF);
            ++i;
        }
        if (endNybble % 2 == 0) {
            value = value * 10 + ((buffer.getByte(offset + i) & 0xF0) >>> 4);
        }
        return value;
    }

    private static final long packedNybblesToLong(ByteBuf buffer, int offset, int startNybble, int numberOfNybbles) {
        long value = 0L;
        int i = startNybble / 2;
        if (startNybble % 2 != 0) {
            value += (long)(buffer.getByte(offset + i) & 0xF);
            ++i;
        }
        int endNybble = startNybble + numberOfNybbles - 1;
        while (i < (endNybble + 1) / 2) {
            value = value * 10L + (long)((buffer.getByte(offset + i) & 0xF0) >>> 4);
            value = value * 10L + (long)(buffer.getByte(offset + i) & 0xF);
            ++i;
        }
        if (endNybble % 2 == 0) {
            value = value * 10L + (long)((buffer.getByte(offset + i) & 0xF0) >>> 4);
        }
        return value;
    }

    private static final int[] computeMagnitude(int[] input) {
        int length = input.length;
        int[] mag = new int[length];
        mag[length - 1] = input[length - 1];
        for (int i = 0; i < length - 1; ++i) {
            int carry = 0;
            int j = tenRadixMagnitude[i].length - 1;
            int k = length - 1;
            while (j >= 0) {
                long product = ((long)input[length - 2 - i] & 0xFFFFFFFFL) * ((long)tenRadixMagnitude[i][j] & 0xFFFFFFFFL) + ((long)mag[k] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
                carry = (int)(product >>> 32);
                mag[k] = (int)(product & 0xFFFFFFFFL);
                --j;
                --k;
            }
            mag[k] = carry;
        }
        return mag;
    }

    public static int computeBigDecimalPrecision(BigDecimal decimal) {
        byte[] bBytes = decimal.unscaledValue().abs().toByteArray();
        if (Decimal.byteArrayCmp(bBytes, tenRadixArr[tenRadixArr.length - 1]) >= 0) {
            throw new IllegalArgumentException("CONN_PRECISION_TOO_LARGE");
        }
        int lo = 0;
        int hi = tenRadixArr.length - 1;
        int mi = (hi + lo) / 2;
        do {
            int compare;
            if ((compare = Decimal.byteArrayCmp(bBytes, tenRadixArr[mi])) == 1) {
                lo = mi;
                continue;
            }
            if (compare != -1) break;
            hi = mi;
        } while ((mi = (hi + lo) / 2) != lo);
        return mi + 1;
    }

    private static int byteArrayCmp(byte[] arg1, byte[] arg2) {
        int arg2Offset;
        int length;
        int arg1Offset;
        int diff;
        if (arg1.length > arg2.length) {
            diff = arg1.length - arg2.length;
            for (arg1Offset = 0; arg1Offset < diff; ++arg1Offset) {
                if (arg1[arg1Offset] == 0) continue;
                return 1;
            }
            length = arg2.length;
        } else if (arg1.length < arg2.length) {
            diff = arg2.length - arg1.length;
            for (arg2Offset = 0; arg2Offset < diff; ++arg2Offset) {
                if (arg2[arg2Offset] == 0) continue;
                return -1;
            }
            length = arg1.length;
        } else {
            length = arg1.length;
        }
        for (int i = 0; i < length; ++i) {
            int b1 = arg1[arg1Offset + i] & 0xFF;
            int b2 = arg2[arg2Offset + i] & 0xFF;
            if (b1 > b2) {
                return 1;
            }
            if (b1 >= b2) continue;
            return -1;
        }
        return 0;
    }

    static BigDecimal getBigDecimal(ByteBuf buffer, int offset, int precision, int scale) {
        int length = precision / 2 + 1;
        int signum = (buffer.getByte(offset + length - 1) & 0xF) == 13 ? -1 : 1;
        if (precision <= 18) {
            long value = Decimal.packedNybblesToLong(buffer, offset, 0, length * 2 - 1);
            if (signum < 0) {
                value = -value;
            }
            return BigDecimal.valueOf(value, scale);
        }
        if (precision <= 27) {
            int lo = Decimal.packedNybblesToInt(buffer, offset, (length - 5) * 2, 9);
            int me = Decimal.packedNybblesToInt(buffer, offset, (length - 10) * 2 + 1, 9);
            int hi = Decimal.packedNybblesToInt(buffer, offset, 0, (length - 10) * 2 + 1);
            int[] value = Decimal.computeMagnitude(new int[]{hi, me, lo});
            byte[] magnitude = new byte[]{(byte)(value[0] >>> 24), (byte)(value[0] >>> 16), (byte)(value[0] >>> 8), (byte)value[0], (byte)(value[1] >>> 24), (byte)(value[1] >>> 16), (byte)(value[1] >>> 8), (byte)value[1], (byte)(value[2] >>> 24), (byte)(value[2] >>> 16), (byte)(value[2] >>> 8), (byte)value[2]};
            return new BigDecimal(new BigInteger(signum, magnitude), scale);
        }
        if (precision <= 31) {
            int lo = Decimal.packedNybblesToInt(buffer, offset, (length - 5) * 2, 9);
            int meLo = Decimal.packedNybblesToInt(buffer, offset, (length - 10) * 2 + 1, 9);
            int meHi = Decimal.packedNybblesToInt(buffer, offset, (length - 14) * 2, 9);
            int hi = Decimal.packedNybblesToInt(buffer, offset, 0, (length - 14) * 2);
            int[] value = Decimal.computeMagnitude(new int[]{hi, meHi, meLo, lo});
            byte[] magnitude = new byte[]{(byte)(value[0] >>> 24), (byte)(value[0] >>> 16), (byte)(value[0] >>> 8), (byte)value[0], (byte)(value[1] >>> 24), (byte)(value[1] >>> 16), (byte)(value[1] >>> 8), (byte)value[1], (byte)(value[2] >>> 24), (byte)(value[2] >>> 16), (byte)(value[2] >>> 8), (byte)value[2], (byte)(value[3] >>> 24), (byte)(value[3] >>> 16), (byte)(value[3] >>> 8), (byte)value[3]};
            return new BigDecimal(new BigInteger(signum, magnitude), scale);
        }
        throw new IllegalArgumentException("SQLState.DECIMAL_TOO_MANY_DIGITS");
    }

    static double getDouble(ByteBuf buffer, int offset, int precision, int scale) {
        int length = precision / 2 + 1;
        int signum = (buffer.getByte(offset + length - 1) & 0xF) == 13 ? -1 : 1;
        if (precision <= 9) {
            int value = Decimal.packedNybblesToInt(buffer, offset, 0, length * 2 - 1);
            return (double)(signum * value) / Math.pow(10.0, scale);
        }
        if (precision <= 18) {
            long value = Decimal.packedNybblesToLong(buffer, offset, 0, length * 2 - 1);
            return (double)((long)signum * value) / Math.pow(10.0, scale);
        }
        if (precision <= 27) {
            int lo = Decimal.packedNybblesToInt(buffer, offset, (length - 5) * 2, 9);
            int me = Decimal.packedNybblesToInt(buffer, offset, (length - 10) * 2 + 1, 9);
            int hi = Decimal.packedNybblesToInt(buffer, offset, 0, (length - 10) * 2 + 1);
            return (double)signum * ((double)lo / Math.pow(10.0, scale) + (double)me * Math.pow(10.0, 9 - scale) + (double)hi * Math.pow(10.0, 18 - scale));
        }
        if (precision <= 31) {
            int lo = Decimal.packedNybblesToInt(buffer, offset, (length - 5) * 2, 9);
            int meLo = Decimal.packedNybblesToInt(buffer, offset, (length - 10) * 2 + 1, 9);
            int meHi = Decimal.packedNybblesToInt(buffer, offset, (length - 14) * 2, 9);
            int hi = Decimal.packedNybblesToInt(buffer, offset, 0, (length - 14) * 2);
            return (double)signum * ((double)lo / Math.pow(10.0, scale) + (double)meLo * Math.pow(10.0, 9 - scale) + (double)meHi * Math.pow(10.0, 18 - scale) + (double)hi * Math.pow(10.0, 27 - scale));
        }
        throw new IllegalArgumentException("SQLState.DECIMAL_TOO_MANY_DIGITS");
    }

    static long getLong(ByteBuf buffer, int offset, int precision, int scale) {
        if (precision > 31) {
            throw new IllegalArgumentException("SQLState.DECIMAL_TOO_MANY_DIGITS");
        }
        int length = precision / 2 + 1;
        int signum = (buffer.getByte(offset + length - 1) & 0xF) == 13 ? -1 : 1;
        if (precision - scale <= 18) {
            int leftOfDecimalPoint = length * 2 - 1 - scale;
            return (long)signum * Decimal.packedNybblesToLong(buffer, offset, 0, leftOfDecimalPoint);
        }
        BigDecimal tmp = new BigDecimal(Decimal.getBigDecimal(buffer, offset, precision, scale).toBigInteger());
        return tmp.longValueExact();
    }

    public static final int bigDecimalToPackedDecimalBytes(ByteBuf buffer, int offset, BigDecimal b, int declaredPrecision, int declaredScale) {
        int bigIndex;
        int declaredWholeIntegerLength;
        if (declaredPrecision > 31) {
            throw new IllegalArgumentException("SQLState.DECIMAL_TOO_MANY_DIGITS " + declaredPrecision);
        }
        String unscaledStr = b.unscaledValue().abs().toString();
        int bigPrecision = unscaledStr.length();
        if (bigPrecision > 31) {
            throw new IllegalArgumentException("SQLState.LANG_OUTSIDE_RANGE_FOR_DATATYPE " + new SqlCode(-405) + "packed decimal");
        }
        int bigScale = b.scale();
        int bigWholeIntegerLength = bigPrecision - bigScale;
        if (bigWholeIntegerLength > 0 && !unscaledStr.equals("0") && bigWholeIntegerLength > (declaredWholeIntegerLength = declaredPrecision - declaredScale)) {
            throw new IllegalArgumentException("SQLState.NUMERIC_OVERFLOW " + new SqlCode(-413) + b.toString() + "packed decimal");
        }
        int zeroBase = 48;
        int packedIndex = declaredPrecision - 1;
        if (bigScale >= declaredScale) {
            bigIndex = bigPrecision - 1 - (bigScale - declaredScale);
            if (bigIndex < 0) {
                buffer.setByte(offset + (packedIndex + 1) / 2, (int)((byte)(b.signum() >= 0 ? 12 : 13)));
            } else {
                buffer.setByte(offset + (packedIndex + 1) / 2, (int)((byte)((unscaledStr.charAt(bigIndex) - zeroBase << 4) + (b.signum() >= 0 ? 12 : 13))));
            }
            packedIndex -= 2;
            bigIndex -= 2;
        } else {
            bigIndex = declaredScale - bigScale - 1;
            buffer.setByte(offset + (packedIndex + 1) / 2, (int)((byte)(b.signum() >= 0 ? 12 : 13)));
            packedIndex -= 2;
            bigIndex -= 2;
            while (bigIndex >= 0) {
                buffer.setByte(offset + (packedIndex + 1) / 2, 0);
                packedIndex -= 2;
                bigIndex -= 2;
            }
            if (bigIndex == -1) {
                buffer.setByte(offset + (packedIndex + 1) / 2, (int)((byte)(unscaledStr.charAt(bigPrecision - 1) - zeroBase << 4)));
                packedIndex -= 2;
                bigIndex = bigPrecision - 3;
            } else {
                bigIndex = bigPrecision - 2;
            }
        }
        while (bigIndex >= 0) {
            buffer.setByte(offset + (packedIndex + 1) / 2, (int)((byte)((unscaledStr.charAt(bigIndex) - zeroBase << 4) + (unscaledStr.charAt(bigIndex + 1) - zeroBase))));
            packedIndex -= 2;
            bigIndex -= 2;
        }
        if (bigIndex == -1) {
            buffer.setByte(offset + (packedIndex + 1) / 2, (int)((byte)(unscaledStr.charAt(0) - zeroBase)));
            packedIndex -= 2;
        }
        while (packedIndex >= -1) {
            buffer.setByte(offset + (packedIndex + 1) / 2, 0);
            packedIndex -= 2;
        }
        return declaredPrecision / 2 + 1;
    }
}

