/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SSLOptions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SSLOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, SSLOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "enabledCipherSuites": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addEnabledCipherSuite((String)item);
                        }
                    });
                    break;
                }
                case "crlPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCrlPath((String)item);
                        }
                    });
                    break;
                }
                case "crlValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCrlValue(Buffer.fromJson((String)item));
                        }
                    });
                    break;
                }
                case "useAlpn": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseAlpn((Boolean)member.getValue());
                    break;
                }
                case "enabledSecureTransportProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setEnabledSecureTransportProtocols(list);
                    break;
                }
                case "sslHandshakeTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSslHandshakeTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "sslHandshakeTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSslHandshakeTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "applicationLayerProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setApplicationLayerProtocols((List<String>)((Object)list));
                }
            }
        }
    }

    static void toJson(SSLOptions obj, JsonObject json) {
        SSLOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(SSLOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getEnabledCipherSuites() != null) {
            array = new JsonArray();
            obj.getEnabledCipherSuites().forEach(item -> array.add(item));
            json.put("enabledCipherSuites", array);
        }
        if (obj.getCrlPaths() != null) {
            array = new JsonArray();
            obj.getCrlPaths().forEach(item -> array.add(item));
            json.put("crlPaths", array);
        }
        if (obj.getCrlValues() != null) {
            array = new JsonArray();
            obj.getCrlValues().forEach(item -> array.add(item.toJson()));
            json.put("crlValues", array);
        }
        json.put("useAlpn", obj.isUseAlpn());
        if (obj.getEnabledSecureTransportProtocols() != null) {
            array = new JsonArray();
            obj.getEnabledSecureTransportProtocols().forEach(item -> array.add(item));
            json.put("enabledSecureTransportProtocols", array);
        }
        json.put("sslHandshakeTimeout", obj.getSslHandshakeTimeout());
        if (obj.getSslHandshakeTimeoutUnit() != null) {
            json.put("sslHandshakeTimeoutUnit", obj.getSslHandshakeTimeoutUnit().name());
        }
        if (obj.getApplicationLayerProtocols() != null) {
            array = new JsonArray();
            obj.getApplicationLayerProtocols().forEach(item -> array.add(item));
            json.put("applicationLayerProtocols", array);
        }
    }
}

