/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

@VertxGen
public interface NetSocket
extends ReadStream<Buffer>,
WriteStream<Buffer> {
    @Override
    public NetSocket exceptionHandler(Handler<Throwable> var1);

    public NetSocket handler(Handler<Buffer> var1);

    public NetSocket pause();

    public NetSocket resume();

    public NetSocket fetch(long var1);

    public NetSocket endHandler(Handler<Void> var1);

    public NetSocket setWriteQueueMaxSize(int var1);

    public NetSocket drainHandler(Handler<Void> var1);

    public String writeHandlerID();

    @Override
    public Future<Void> write(String var1);

    public Future<Void> write(String var1, String var2);

    default public Future<Void> sendFile(String filename) {
        return this.sendFile(filename, 0L, Long.MAX_VALUE);
    }

    default public Future<Void> sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, Long.MAX_VALUE);
    }

    public Future<Void> sendFile(String var1, long var2, long var4);

    @CacheReturn
    public SocketAddress remoteAddress();

    public SocketAddress remoteAddress(boolean var1);

    @CacheReturn
    public SocketAddress localAddress();

    public SocketAddress localAddress(boolean var1);

    @Override
    public Future<Void> end();

    public Future<Void> close();

    @Fluent
    public NetSocket closeHandler(@Nullable Handler<Void> var1);

    @Fluent
    public NetSocket shutdownHandler(@Nullable Handler<Void> var1);

    default public Future<Void> upgradeToSsl() {
        return this.upgradeToSsl(null, null, null);
    }

    default public Future<Void> upgradeToSsl(Buffer msg) {
        return this.upgradeToSsl(null, null, msg);
    }

    default public Future<Void> upgradeToSsl(String serverName) {
        return this.upgradeToSsl(null, serverName, null);
    }

    default public Future<Void> upgradeToSsl(String serverName, Buffer msg) {
        return this.upgradeToSsl(null, serverName, msg);
    }

    default public Future<Void> upgradeToSsl(SSLOptions sslOptions, String serverName) {
        return this.upgradeToSsl(sslOptions, serverName, null);
    }

    default public Future<Void> upgradeToSsl(SSLOptions sslOptions, Buffer msg) {
        return this.upgradeToSsl(sslOptions, null, msg);
    }

    public Future<Void> upgradeToSsl(SSLOptions var1, String var2, Buffer var3);

    default public Future<Void> upgradeToSsl(SSLOptions sslOptions) {
        return this.upgradeToSsl(sslOptions, null, null);
    }

    public boolean isSsl();

    @GenIgnore(value={"permitted-type"})
    public SSLSession sslSession();

    @GenIgnore
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException;

    public String indicatedServerName();

    public String applicationLayerProtocol();
}

