/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.buffer;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.net.impl.VertxHandler;
import java.nio.ByteBuffer;
import java.util.Objects;

public interface BufferInternal
extends Buffer {
    public static BufferInternal safeBuffer(ByteBuf byteBuf) {
        return BufferInternal.buffer(VertxHandler.safeBuffer(byteBuf));
    }

    public static BufferInternal buffer(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf);
        return new BufferImpl(byteBuf);
    }

    public static BufferInternal buffer(int initialSizeHint) {
        return new BufferImpl(initialSizeHint);
    }

    public static BufferInternal buffer() {
        return new BufferImpl();
    }

    public static BufferInternal buffer(String str) {
        return new BufferImpl(str);
    }

    public static BufferInternal buffer(String str, String enc) {
        return new BufferImpl(str, enc);
    }

    public static BufferInternal buffer(byte[] bytes) {
        return new BufferImpl(bytes);
    }

    @Override
    public BufferInternal appendBuffer(Buffer var1);

    @Override
    public BufferInternal appendBuffer(Buffer var1, int var2, int var3);

    @Override
    public BufferInternal appendBytes(byte[] var1);

    @Override
    public BufferInternal appendBytes(byte[] var1, int var2, int var3);

    @Override
    public BufferInternal appendByte(byte var1);

    @Override
    public BufferInternal appendUnsignedByte(short var1);

    @Override
    public BufferInternal appendInt(int var1);

    @Override
    public BufferInternal appendIntLE(int var1);

    @Override
    public BufferInternal appendUnsignedInt(long var1);

    @Override
    public BufferInternal appendUnsignedIntLE(long var1);

    @Override
    public BufferInternal appendMedium(int var1);

    @Override
    public BufferInternal appendMediumLE(int var1);

    @Override
    public BufferInternal appendLong(long var1);

    @Override
    public BufferInternal appendLongLE(long var1);

    @Override
    public BufferInternal appendShort(short var1);

    @Override
    public BufferInternal appendShortLE(short var1);

    @Override
    public BufferInternal appendUnsignedShort(int var1);

    @Override
    public BufferInternal appendUnsignedShortLE(int var1);

    @Override
    public BufferInternal appendFloat(float var1);

    @Override
    public BufferInternal appendFloatLE(float var1);

    @Override
    public BufferInternal appendDouble(double var1);

    @Override
    public BufferInternal appendDoubleLE(double var1);

    @Override
    public BufferInternal appendString(String var1, String var2);

    @Override
    public BufferInternal appendString(String var1);

    @Override
    public BufferInternal setByte(int var1, byte var2);

    @Override
    public BufferInternal setUnsignedByte(int var1, short var2);

    @Override
    public BufferInternal setInt(int var1, int var2);

    @Override
    public BufferInternal setIntLE(int var1, int var2);

    @Override
    public BufferInternal setUnsignedInt(int var1, long var2);

    @Override
    public BufferInternal setUnsignedIntLE(int var1, long var2);

    @Override
    public BufferInternal setMedium(int var1, int var2);

    @Override
    public BufferInternal setMediumLE(int var1, int var2);

    @Override
    public BufferInternal setLong(int var1, long var2);

    @Override
    public BufferInternal setLongLE(int var1, long var2);

    @Override
    public BufferInternal setDouble(int var1, double var2);

    @Override
    public BufferInternal setDoubleLE(int var1, double var2);

    @Override
    public BufferInternal setFloat(int var1, float var2);

    @Override
    public BufferInternal setFloatLE(int var1, float var2);

    @Override
    public BufferInternal setShort(int var1, short var2);

    @Override
    public BufferInternal setShortLE(int var1, short var2);

    @Override
    public BufferInternal setUnsignedShort(int var1, int var2);

    @Override
    public BufferInternal setUnsignedShortLE(int var1, int var2);

    @Override
    public BufferInternal setBuffer(int var1, Buffer var2);

    @Override
    public BufferInternal setBuffer(int var1, Buffer var2, int var3, int var4);

    @Override
    public BufferInternal setBytes(int var1, ByteBuffer var2);

    @Override
    public BufferInternal setBytes(int var1, byte[] var2);

    @Override
    public BufferInternal setBytes(int var1, byte[] var2, int var3, int var4);

    @Override
    public BufferInternal setString(int var1, String var2);

    @Override
    public BufferInternal setString(int var1, String var2, String var3);

    @Override
    public BufferInternal copy();

    @Override
    public BufferInternal slice();

    @Override
    public BufferInternal slice(int var1, int var2);

    public ByteBuf getByteBuf();
}

