/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import java.io.File;
import java.util.OptionalInt;
import java.util.OptionalLong;

public enum SysProps {
    DISABLE_HTTP_HEADERS_VALIDATION("vertx.disableHttpHeadersValidation"),
    DISABLE_WEBSOCKETS("vertx.disableWebsockets"),
    DISABLE_METRICS("vertx.disableMetrics"),
    DISABLE_CONTEXT_TIMINGS("vertx.disableContextTimings"),
    DISABLE_DNS_RESOLVER("vertx.disableDnsResolver"),
    DISABLE_FILE_CACHING("vertx.disableFileCaching"),
    DISABLE_FILE_CP_RESOLVING("vertx.disableFileCPResolving"),
    FILE_CACHE_DIR("vertx.cacheDirBase"){

        @Override
        public String get() {
            Object val = super.get();
            if (val == null) {
                String tmpDir = System.getProperty("java.io.tmpdir", ".");
                String cacheDirBase = "vertx-cache";
                val = tmpDir + File.separator + cacheDirBase;
            }
            return val;
        }
    }
    ,
    CACHE_IMMUTABLE_HTTP_RESPONSE_HEADERS("vertx.cacheImmutableHttpResponseHeaders"),
    INTERN_COMMON_HTTP_REQUEST_HEADERS_TO_LOWER_CASE("vertx.internCommonHttpRequestHeadersToLowerCase"),
    LOGGER_DELEGATE_FACTORY_CLASS_NAME("vertx.logger-delegate-factory-class-name"),
    JACKSON_DEFAULT_READ_MAX_NESTING_DEPTH("vertx.jackson.defaultReadMaxNestingDepth"),
    JACKSON_DEFAULT_READ_MAX_DOC_LEN("vertx.jackson.defaultReadMaxDocumentLength"),
    JACKSON_DEFAULT_READ_MAX_NUM_LEN("vertx.jackson.defaultReadMaxNumberLength"),
    JACKSON_DEFAULT_READ_MAX_STRING_LEN("vertx.jackson.defaultReadMaxStringLength"),
    JACKSON_DEFAULT_READ_MAX_NAME_LEN("vertx.jackson.defaultReadMaxNameLength"),
    JACKSON_DEFAULT_READ_MAX_TOKEN_COUNT("vertx.jackson.defaultMaxTokenCount");

    public final String name;

    private SysProps(String name) {
        this.name = name;
    }

    public String get() {
        return System.getProperty(this.name);
    }

    public OptionalLong getAsLong() throws NumberFormatException {
        String s = this.get();
        if (s != null) {
            return OptionalLong.of(Long.parseLong(s));
        }
        return OptionalLong.empty();
    }

    public OptionalInt getAsInt() throws NumberFormatException {
        String s = this.get();
        if (s != null) {
            return OptionalInt.of(Integer.parseInt(s));
        }
        return OptionalInt.empty();
    }

    public boolean getBoolean() {
        return Boolean.getBoolean(this.name);
    }
}

