/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;

class ReplyHandler<T>
extends HandlerRegistration<T>
implements Handler<Long> {
    private static final Completable<Void> NULL_COMPLETABLE = (res, err) -> {};
    private final Promise<Message<T>> result;
    private final long timeoutID;
    private final long timeout;
    private final String repliedAddress;
    Object trace;

    ReplyHandler(EventBusImpl eventBus, ContextInternal context, String address, String repliedAddress, boolean src, long timeout) {
        super(context, eventBus, address, src);
        this.result = context.promise();
        this.repliedAddress = repliedAddress;
        this.timeoutID = context.setTimer(timeout, this);
        this.timeout = timeout;
    }

    private void trace(Object reply, Throwable failure) {
        VertxTracer tracer = this.context.tracer();
        Object trace = this.trace;
        if (tracer != null && this.src && trace != null) {
            tracer.receiveResponse(this.context, reply, trace, failure, TagExtractor.empty());
        }
    }

    Future<Message<T>> result() {
        return this.result.future();
    }

    void fail(ReplyException failure) {
        if (this.context.owner().cancelTimer(this.timeoutID)) {
            this.unregister();
            this.doFail(failure);
        }
    }

    private void doFail(ReplyException failure) {
        this.trace(null, failure);
        this.result.fail(failure);
        if (this.bus.metrics != null) {
            this.bus.metrics.replyFailure(this.repliedAddress, failure.failureType());
        }
    }

    @Override
    public void handle(Long id) {
        this.unregister();
        this.doFail(new ReplyException(ReplyFailure.TIMEOUT, "Timed out after waiting " + this.timeout + "(ms) for a reply. address: " + this.address + ", repliedAddress: " + this.repliedAddress));
    }

    @Override
    protected void doReceive(Message<T> reply) {
        this.dispatch(null, reply, this.context);
    }

    void register() {
        this.register(false, false, NULL_COMPLETABLE);
    }

    @Override
    protected void dispatch(Message<T> reply, ContextInternal context, Handler<Message<T>> handler) {
        if (context.owner().cancelTimer(this.timeoutID)) {
            this.unregister();
            if (reply.body() instanceof ReplyException) {
                this.doFail((ReplyException)reply.body());
            } else {
                this.trace(reply, null);
                this.result.complete(reply);
            }
        }
    }
}

