/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.impl.AbstractContext;
import io.vertx.core.impl.CloseHooks;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DuplicatedContext;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;

public class WorkerContext
extends ContextImpl {
    WorkerContext(VertxInternal vertx, VertxTracer<?, ?> tracer, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, CloseHooks closeHooks, ClassLoader tccl) {
        super(vertx, tracer, vertx.getEventLoopGroup().next(), internalBlockingPool, workerPool, deployment, closeHooks, tccl);
    }

    @Override
    void runOnContext(AbstractContext ctx, Handler<Void> action) {
        try {
            TaskQueue orderedTasks = ctx instanceof DuplicatedContext ? ((DuplicatedContext)ctx).orderedTasks() : this.orderedTasks;
            this.run(ctx, orderedTasks, null, action);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    <T> void execute(AbstractContext ctx, T argument, Handler<T> task) {
        TaskQueue orderedTasks = ctx instanceof DuplicatedContext ? ((DuplicatedContext)ctx).orderedTasks() : this.orderedTasks;
        this.execute(orderedTasks, argument, task);
    }

    @Override
    <T> void emit(AbstractContext ctx, T argument, Handler<T> task) {
        TaskQueue orderedTasks = ctx instanceof DuplicatedContext ? ((DuplicatedContext)ctx).orderedTasks() : this.orderedTasks;
        this.execute(orderedTasks, argument, (T arg) -> ctx.dispatch(arg, task));
    }

    @Override
    <T> void execute(AbstractContext ctx, Runnable task) {
        this.execute(this, task, Runnable::run);
    }

    @Override
    public boolean isEventLoopContext() {
        return false;
    }

    private <T> void run(ContextInternal ctx, TaskQueue queue, T value, Handler<T> task) {
        Objects.requireNonNull(task, "Task handler must not be null");
        PoolMetrics metrics = this.workerPool.metrics();
        Object queueMetric = metrics != null ? metrics.submitted() : null;
        queue.execute(() -> {
            Object execMetric = null;
            if (metrics != null) {
                execMetric = metrics.begin(queueMetric);
            }
            try {
                ctx.dispatch(value, task);
            }
            finally {
                if (metrics != null) {
                    metrics.end(execMetric, true);
                }
            }
        }, this.workerPool.executor());
    }

    private <T> void execute(TaskQueue queue, T argument, Handler<T> task) {
        if (Context.isOnWorkerThread()) {
            task.handle(argument);
        } else {
            PoolMetrics metrics = this.workerPool.metrics();
            Object queueMetric = metrics != null ? metrics.submitted() : null;
            queue.execute(() -> {
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                try {
                    task.handle(argument);
                }
                finally {
                    if (metrics != null) {
                        metrics.end(execMetric, true);
                    }
                }
            }, this.workerPool.executor());
        }
    }

    @Override
    boolean inThread() {
        return Context.isOnWorkerThread();
    }
}

