/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.impl.ChannelProvider;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.ProxyChannelProvider;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class NetClientBase<C extends ConnectionBase>
implements MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(NetClientBase.class);
    private final VertxInternal vertx;
    private final NetClientOptions options;
    protected final SSLHelper sslHelper;
    private final Map<Channel, C> socketMap = new ConcurrentHashMap<Channel, C>();
    private final Closeable closeHook;
    private final ContextImpl creatingContext;
    private final TCPMetrics metrics;
    private volatile boolean closed;

    public NetClientBase(VertxInternal vertx, NetClientOptions options, boolean useCreatingContext) {
        this.vertx = vertx;
        this.options = new NetClientOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (useCreatingContext) {
            this.creatingContext = vertx.getContext();
            if (this.creatingContext != null) {
                if (this.creatingContext.isMultiThreadedWorkerContext()) {
                    throw new IllegalStateException("Cannot use NetClient in a multi-threaded worker verticle");
                }
                this.creatingContext.addCloseHook(this.closeHook);
            }
        } else {
            this.creatingContext = null;
        }
        this.metrics = vertx.metricsSPI().createMetrics(options);
    }

    protected abstract C createConnection(VertxInternal var1, Channel var2, String var3, int var4, ContextImpl var5, SSLHelper var6, TCPMetrics var7);

    protected abstract void handleMsgReceived(C var1, Object var2);

    protected abstract void initChannel(ChannelPipeline var1);

    protected abstract Object safeObject(Object var1, ByteBufAllocator var2);

    public void close() {
        if (!this.closed) {
            for (ConnectionBase sock : this.socketMap.values()) {
                sock.close();
            }
            if (this.creatingContext != null) {
                this.creatingContext.removeCloseHook(this.closeHook);
            }
            this.closed = true;
            this.metrics.close();
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    private void applyConnectionOptions(Bootstrap bootstrap) {
        if (this.options.getLocalAddress() != null) {
            bootstrap.localAddress(this.options.getLocalAddress(), 0);
        }
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.options.isTcpNoDelay());
        if (this.options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.options.getSendBufferSize());
        }
        if (this.options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.options.getReceiveBufferSize()));
        }
        if (this.options.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, (Object)this.options.getSoLinger());
        }
        if (this.options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)this.options.getTrafficClass());
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.options.getConnectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.options.isTcpKeepAlive());
    }

    protected void doConnect(int port, String host, String serverName, Handler<AsyncResult<C>> connectHandler) {
        this.doConnect(port, host, serverName, connectHandler, this.options.getReconnectAttempts());
    }

    protected void doConnect(int port, String host, String serverName, Handler<AsyncResult<C>> connectHandler, int remainingAttempts) {
        this.checkClosed();
        Objects.requireNonNull(host, "No null host accepted");
        Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
        ContextImpl context = this.vertx.getOrCreateContext();
        this.sslHelper.validate(this.vertx);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)context.nettyEventLoop());
        bootstrap.channel(NioSocketChannel.class);
        this.applyConnectionOptions(bootstrap);
        ChannelProvider channelProvider = this.options.getProxyOptions() == null ? ChannelProvider.INSTANCE : ProxyChannelProvider.INSTANCE;
        Handler<Channel> channelInitializer = ch -> {
            ChannelPipeline pipeline = ch.pipeline();
            if (this.sslHelper.isSSL()) {
                SslHandler sslHandler = new SslHandler(this.sslHelper.createEngine(this.vertx, host, port, serverName));
                ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
            }
            this.initChannel(pipeline);
            pipeline.addLast("handler", (ChannelHandler)new VertxNetHandler<C>((Channel)ch, (Map)this.socketMap){

                @Override
                protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
                    return NetClientBase.this.safeObject(msg, allocator);
                }

                @Override
                protected void handleMsgReceived(C conn, Object msg) {
                    NetClientBase.this.handleMsgReceived(conn, msg);
                }
            });
        };
        Handler<AsyncResult<Channel>> channelHandler = res -> {
            if (res.succeeded()) {
                Channel ch = (Channel)res.result();
                if (this.sslHelper.isSSL()) {
                    SslHandler sslHandler = (SslHandler)ch.pipeline().get("ssl");
                    io.netty.util.concurrent.Future fut = sslHandler.handshakeFuture();
                    fut.addListener(future2 -> {
                        if (future2.isSuccess()) {
                            this.connected(context, ch, connectHandler, host, port);
                        } else {
                            this.failed(context, ch, future2.cause(), connectHandler);
                        }
                    });
                } else {
                    this.connected(context, ch, connectHandler, host, port);
                }
            } else if (remainingAttempts > 0 || remainingAttempts == -1) {
                context.executeFromIO(() -> {
                    log.debug("Failed to create connection. Will retry in " + this.options.getReconnectInterval() + " milliseconds");
                    this.vertx.setTimer(this.options.getReconnectInterval(), tid -> this.doConnect(port, host, serverName, connectHandler, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1));
                });
            } else {
                this.failed(context, null, res.cause(), connectHandler);
            }
        };
        channelProvider.connect(this.vertx, bootstrap, this.options.getProxyOptions(), host, port, channelInitializer, channelHandler);
    }

    private void connected(ContextImpl context, Channel ch, Handler<AsyncResult<C>> connectHandler, String host, int port) {
        ContextImpl.setContext(context);
        C sock = this.createConnection(this.vertx, ch, host, port, context, this.sslHelper, this.metrics);
        VertxNetHandler handler = (VertxNetHandler)ch.pipeline().get(VertxNetHandler.class);
        handler.conn = sock;
        this.socketMap.put(ch, sock);
        context.executeFromIO(() -> {
            sock.metric(this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
            connectHandler.handle(Future.succeededFuture(sock));
        });
    }

    private void failed(ContextImpl context, Channel ch, Throwable th, Handler<AsyncResult<C>> connectHandler) {
        if (ch != null) {
            ch.close();
        }
        context.executeFromIO(() -> this.doFailed(connectHandler, th));
    }

    private void doFailed(Handler<AsyncResult<C>> connectHandler, Throwable th) {
        connectHandler.handle(Future.failedFuture(th));
    }
}

