/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.resolver;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.HostsFileParser;
import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.spi.resolver.ResolverProvider;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DnsResolverProvider
implements ResolverProvider {
    private final Vertx vertx;
    private final List<ResolverRegistration> resolvers = Collections.synchronizedList(new ArrayList());
    private AddressResolverGroup<InetSocketAddress> resolverGroup;

    public DnsResolverProvider(VertxImpl vertx, final AddressResolverOptions options) {
        Map entries;
        DnsServerAddresses nameServerAddresses;
        List<String> dnsServers = options.getServers();
        ArrayList<InetSocketAddress> serverList = new ArrayList<InetSocketAddress>();
        if (dnsServers != null && dnsServers.size() > 0) {
            for (String dnsServer : dnsServers) {
                int port;
                String ipAddress;
                int sep = dnsServer.indexOf(58);
                if (sep != -1) {
                    ipAddress = dnsServer.substring(0, sep);
                    port = Integer.parseInt(dnsServer.substring(sep + 1));
                } else {
                    ipAddress = dnsServer;
                    port = 53;
                }
                try {
                    serverList.add(new InetSocketAddress(InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString((String)ipAddress)), port));
                }
                catch (UnknownHostException e) {
                    throw new VertxException(e);
                }
            }
        } else {
            InetSocketAddress address;
            DnsServerAddressStream stream = DnsServerAddresses.defaultAddresses().stream();
            HashSet<InetSocketAddress> all = new HashSet<InetSocketAddress>();
            while (!all.contains(address = stream.next())) {
                serverList.add(address);
                all.add(address);
            }
        }
        DnsServerAddresses dnsServerAddresses = nameServerAddresses = options.isRotateServers() ? DnsServerAddresses.rotational(serverList) : DnsServerAddresses.sequential(serverList);
        if (options.getHostsPath() != null) {
            File file = vertx.resolveFile(options.getHostsPath()).getAbsoluteFile();
            try {
                if (!file.exists() || !file.isFile()) {
                    throw new IOException();
                }
                entries = HostsFileParser.parse((File)file);
            }
            catch (IOException e) {
                throw new VertxException("Cannot read hosts file " + file.getAbsolutePath());
            }
        } else if (options.getHostsValue() != null) {
            try {
                entries = HostsFileParser.parse((Reader)new StringReader(options.getHostsValue().toString()));
            }
            catch (IOException e) {
                throw new VertxException("Cannot read hosts config ", e);
            }
        } else {
            entries = HostsFileParser.parseSilently();
        }
        this.vertx = vertx;
        this.resolverGroup = new AddressResolverGroup<InetSocketAddress>(){

            protected io.netty.resolver.AddressResolver<InetSocketAddress> newResolver(final EventExecutor executor) throws Exception {
                DnsAddressResolverGroup group = new DnsAddressResolverGroup(NioDatagramChannel.class, nameServerAddresses){

                    protected NameResolver<InetAddress> newNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddresses nameServerAddresses) throws Exception {
                        DnsNameResolverBuilder builder = new DnsNameResolverBuilder((EventLoop)executor);
                        builder.hostsFileEntriesResolver(inetHost -> {
                            InetAddress addr = (InetAddress)entries.get(inetHost);
                            if (addr == null) {
                                addr = (InetAddress)entries.get(inetHost.toLowerCase(Locale.ENGLISH));
                            }
                            return addr;
                        });
                        builder.channelType(NioDatagramChannel.class);
                        builder.nameServerAddresses(nameServerAddresses);
                        builder.optResourceEnabled(options.isOptResourceEnabled());
                        builder.ttl(options.getCacheMinTimeToLive(), options.getCacheMaxTimeToLive());
                        builder.negativeTtl(options.getCacheNegativeTimeToLive());
                        builder.queryTimeoutMillis(options.getQueryTimeout());
                        builder.maxQueriesPerResolve(options.getMaxQueries());
                        builder.recursionDesired(options.getRdFlag());
                        if (options.getSearchDomains() != null) {
                            builder.searchDomains(options.getSearchDomains());
                            int ndots = options.getNdots();
                            if (ndots == -1) {
                                ndots = AddressResolver.DEFAULT_NDOTS_RESOLV_OPTION;
                            }
                            builder.ndots(ndots);
                        }
                        return builder.build();
                    }
                };
                io.netty.resolver.AddressResolver resolver = group.getResolver(executor);
                DnsResolverProvider.this.resolvers.add(new ResolverRegistration((io.netty.resolver.AddressResolver<InetSocketAddress>)resolver, (EventLoop)executor));
                return resolver;
            }
        };
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions options) {
        return this.resolverGroup;
    }

    @Override
    public void close(Handler<Void> doneHandler) {
        Context context = this.vertx.getOrCreateContext();
        ResolverRegistration[] registrations = this.resolvers.toArray(new ResolverRegistration[this.resolvers.size()]);
        if (registrations.length == 0) {
            context.runOnContext(doneHandler);
            return;
        }
        AtomicInteger count = new AtomicInteger(registrations.length);
        for (ResolverRegistration registration : registrations) {
            Runnable task = () -> {
                registration.resolver.close();
                if (count.decrementAndGet() == 0) {
                    context.runOnContext(doneHandler);
                }
            };
            if (registration.executor.inEventLoop()) {
                task.run();
                continue;
            }
            registration.executor.execute(task);
        }
    }

    private static class ResolverRegistration {
        private final io.netty.resolver.AddressResolver<InetSocketAddress> resolver;
        private final EventLoop executor;

        ResolverRegistration(io.netty.resolver.AddressResolver<InetSocketAddress> resolver, EventLoop executor) {
            this.resolver = resolver;
            this.executor = executor;
        }
    }
}

