/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.converters;

import io.vertx.core.cli.converters.BooleanConverter;
import io.vertx.core.cli.converters.CharacterConverter;
import io.vertx.core.cli.converters.ConstructorBasedConverter;
import io.vertx.core.cli.converters.Converter;
import io.vertx.core.cli.converters.FromBasedConverter;
import io.vertx.core.cli.converters.FromStringBasedConverter;
import io.vertx.core.cli.converters.StringConverter;
import io.vertx.core.cli.converters.ValueOfBasedConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class Converters {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;

    public static <T> T create(Class<T> type, String value) {
        if (type.isPrimitive()) {
            type = Converters.wrap(type);
        }
        return Converters.getConverter(type).fromString(value);
    }

    public static <T> T create(String value, Converter<T> converter) {
        return converter.fromString(value);
    }

    private static <T> Class<T> wrap(Class<T> type) {
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return wrapped == null ? type : wrapped;
    }

    private static <T> Converter<T> getConverter(Class<T> type) {
        if (type == String.class) {
            return StringConverter.INSTANCE;
        }
        if (type == Boolean.class) {
            return BooleanConverter.INSTANCE;
        }
        Converter<T> converter = ConstructorBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = ValueOfBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = FromBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = FromStringBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        if (type == Character.class) {
            return CharacterConverter.INSTANCE;
        }
        throw new NoSuchElementException("Cannot find a converter able to create instance of " + type.getName());
    }

    public static <T> Converter<T> newInstance(Class<? extends Converter<T>> type) throws IllegalArgumentException {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot create a new instance of " + type.getName() + " - it requires an public constructor without argument", e);
        }
    }

    static {
        HashMap<Class<Object>, Class<Void>> primToWrap = new HashMap<Class<Object>, Class<Void>>(16);
        primToWrap.put(Boolean.TYPE, Boolean.class);
        primToWrap.put(Byte.TYPE, Byte.class);
        primToWrap.put(Character.TYPE, Character.class);
        primToWrap.put(Double.TYPE, Double.class);
        primToWrap.put(Float.TYPE, Float.class);
        primToWrap.put(Integer.TYPE, Integer.class);
        primToWrap.put(Long.TYPE, Long.class);
        primToWrap.put(Short.TYPE, Short.class);
        primToWrap.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
    }
}

