/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;

class FutureImpl<T>
implements Future<T> {
    private boolean failed;
    private boolean succeeded;
    private Handler<AsyncResult<T>> handler;
    private T result;
    private Throwable throwable;

    FutureImpl() {
    }

    FutureImpl(Throwable t) {
        if (t == null) {
            this.complete(null);
        } else {
            this.fail(t);
        }
    }

    FutureImpl(String failureMessage, boolean failed) {
        this(new NoStackTraceThrowable(failureMessage));
    }

    FutureImpl(T result) {
        this.complete(result);
    }

    @Override
    public T result() {
        return this.result;
    }

    @Override
    public Throwable cause() {
        return this.throwable;
    }

    @Override
    public boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public boolean failed() {
        return this.failed;
    }

    @Override
    public boolean isComplete() {
        return this.failed || this.succeeded;
    }

    @Override
    public void setHandler(Handler<AsyncResult<T>> handler) {
        this.handler = handler;
        this.checkCallHandler();
    }

    @Override
    public void complete(T result) {
        this.checkComplete();
        this.result = result;
        this.succeeded = true;
        this.checkCallHandler();
    }

    @Override
    public void complete() {
        this.complete(null);
    }

    @Override
    public void fail(Throwable throwable) {
        this.checkComplete();
        this.throwable = throwable;
        this.failed = true;
        this.checkCallHandler();
    }

    @Override
    public void fail(String failureMessage) {
        this.fail(new NoStackTraceThrowable(failureMessage));
    }

    private void checkCallHandler() {
        if (this.handler != null && this.isComplete()) {
            this.handler.handle(this);
        }
    }

    private void checkComplete() {
        if (this.succeeded || this.failed) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }
}

