/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;

public class WebSocketImpl
extends WebSocketImplBase
implements WebSocket {
    private Object metric;

    public WebSocketImpl(VertxInternal vertx, ClientConnection conn, boolean supportsContinuation, int maxWebSocketFrameSize) {
        super(vertx, conn, supportsContinuation, maxWebSocketFrameSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket handler(Handler<Buffer> handler) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.dataHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket endHandler(Handler<Void> handler) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket exceptionHandler(Handler<Throwable> handler) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    @Override
    public WebSocket writeFrame(WebSocketFrame frame) {
        this.writeFrameInternal(frame);
        return this;
    }

    @Override
    public WebSocket writeFinalTextFrame(String text) {
        return this.writeFrame(WebSocketFrame.textFrame(text, true));
    }

    @Override
    public WebSocket writeFinalBinaryFrame(Buffer data) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true));
    }

    @Override
    public WebSocket writeBinaryMessage(Buffer data) {
        this.writeMessageInternal(data);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket closeHandler(Handler<Void> handler) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.checkClosed();
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket frameHandler(Handler<WebSocketFrame> handler) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.checkClosed();
            this.frameHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket pause() {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.checkClosed();
            this.conn.doPause();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket resume() {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.checkClosed();
            this.conn.doResume();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket setWriteQueueMaxSize(int maxSize) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.checkClosed();
            this.conn.doSetWriteQueueMaxSize(maxSize);
            return this;
        }
    }

    @Override
    public WebSocket write(Buffer data) {
        this.writeFrame(WebSocketFrame.binaryFrame(data, true));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket drainHandler(Handler<Void> handler) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.checkClosed();
            this.drainHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleClosed() {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            ((ClientConnection)this.conn).metrics().disconnected(this.metric);
            super.handleClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMetric(Object metric) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.metric = metric;
        }
    }
}

