/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.netty.decoder;

import io.netty.buffer.ByteBuf;
import io.vertx.core.dns.impl.netty.DnsResource;
import io.vertx.core.dns.impl.netty.DnsResponse;
import io.vertx.core.dns.impl.netty.DnsResponseDecoder;
import io.vertx.core.dns.impl.netty.decoder.RecordDecoder;
import io.vertx.core.dns.impl.netty.decoder.record.ServiceRecord;

public class ServiceDecoder
implements RecordDecoder<ServiceRecord> {
    @Override
    public ServiceRecord decode(DnsResponse response, DnsResource resource) {
        ByteBuf packet = response.content().readerIndex(resource.contentIndex());
        short priority = packet.readShort();
        short weight = packet.readShort();
        int port = packet.readUnsignedShort();
        String target = DnsResponseDecoder.readName(packet);
        return new ServiceRecord(resource.name(), priority, weight, port, target);
    }
}

