/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.ManagedListener;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;

public class ApplicationListeners
implements Lifecycle {
    private static final ManagedListener[] EMPTY = new ManagedListener[0];
    private static final Class[] LISTENER_CLASSES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class, HttpSessionIdListener.class};
    private static final ThreadLocal<ListenerState> IN_PROGRAMATIC_SC_LISTENER_INVOCATION = new ThreadLocal<ListenerState>(){

        @Override
        protected ListenerState initialValue() {
            return ListenerState.NO_LISTENER;
        }
    };
    private ServletContext servletContext;
    private final List<ManagedListener> allListeners = new ArrayList<ManagedListener>();
    private ManagedListener[] servletContextListeners;
    private ManagedListener[] servletContextAttributeListeners;
    private ManagedListener[] servletRequestListeners;
    private ManagedListener[] servletRequestAttributeListeners;
    private ManagedListener[] httpSessionListeners;
    private ManagedListener[] httpSessionAttributeListeners;
    private ManagedListener[] httpSessionIdListeners;
    private volatile boolean started = false;

    public ApplicationListeners(List<ManagedListener> allListeners, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.servletContextListeners = EMPTY;
        this.servletContextAttributeListeners = EMPTY;
        this.servletRequestListeners = EMPTY;
        this.servletRequestAttributeListeners = EMPTY;
        this.httpSessionListeners = EMPTY;
        this.httpSessionAttributeListeners = EMPTY;
        this.httpSessionIdListeners = EMPTY;
        for (ManagedListener listener : allListeners) {
            this.addListener(listener);
        }
    }

    public void addListener(ManagedListener listener) {
        ManagedListener[] old;
        if (ServletContextListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            old = this.servletContextListeners;
            this.servletContextListeners = new ManagedListener[old.length + 1];
            System.arraycopy(old, 0, this.servletContextListeners, 0, old.length);
            this.servletContextListeners[old.length] = listener;
        }
        if (ServletContextAttributeListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            old = this.servletContextAttributeListeners;
            this.servletContextAttributeListeners = new ManagedListener[old.length + 1];
            System.arraycopy(old, 0, this.servletContextAttributeListeners, 0, old.length);
            this.servletContextAttributeListeners[old.length] = listener;
        }
        if (ServletRequestListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            old = this.servletRequestListeners;
            this.servletRequestListeners = new ManagedListener[old.length + 1];
            System.arraycopy(old, 0, this.servletRequestListeners, 0, old.length);
            this.servletRequestListeners[old.length] = listener;
        }
        if (ServletRequestAttributeListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            old = this.servletRequestAttributeListeners;
            this.servletRequestAttributeListeners = new ManagedListener[old.length + 1];
            System.arraycopy(old, 0, this.servletRequestAttributeListeners, 0, old.length);
            this.servletRequestAttributeListeners[old.length] = listener;
        }
        if (HttpSessionListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            old = this.httpSessionListeners;
            this.httpSessionListeners = new ManagedListener[old.length + 1];
            System.arraycopy(old, 0, this.httpSessionListeners, 0, old.length);
            this.httpSessionListeners[old.length] = listener;
        }
        if (HttpSessionAttributeListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            old = this.httpSessionAttributeListeners;
            this.httpSessionAttributeListeners = new ManagedListener[old.length + 1];
            System.arraycopy(old, 0, this.httpSessionAttributeListeners, 0, old.length);
            this.httpSessionAttributeListeners[old.length] = listener;
        }
        if (HttpSessionIdListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            old = this.httpSessionIdListeners;
            this.httpSessionIdListeners = new ManagedListener[old.length + 1];
            System.arraycopy(old, 0, this.httpSessionIdListeners, 0, old.length);
            this.httpSessionIdListeners[old.length] = listener;
        }
        this.allListeners.add(listener);
        if (this.started) {
            try {
                listener.start();
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void start() throws ServletException {
        this.started = true;
        for (ManagedListener listener : this.allListeners) {
            listener.start();
        }
    }

    @Override
    public void stop() {
        if (this.started) {
            this.started = false;
            for (ManagedListener listener : this.allListeners) {
                listener.stop();
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized() {
        if (!this.started) {
            return;
        }
        ServletContextEvent event = new ServletContextEvent(this.servletContext);
        for (int i = 0; i < this.servletContextListeners.length; ++i) {
            ManagedListener listener = this.servletContextListeners[i];
            IN_PROGRAMATIC_SC_LISTENER_INVOCATION.set(listener.isProgramatic() ? ListenerState.PROGRAMATIC_LISTENER : ListenerState.DECLARED_LISTENER);
            try {
                ((ServletContextListener)this.get(listener)).contextInitialized(event);
                continue;
            }
            finally {
                IN_PROGRAMATIC_SC_LISTENER_INVOCATION.remove();
            }
        }
    }

    public void contextDestroyed() {
        if (!this.started) {
            return;
        }
        ServletContextEvent event = new ServletContextEvent(this.servletContext);
        for (int i = this.servletContextListeners.length - 1; i >= 0; --i) {
            ManagedListener listener = this.servletContextListeners[i];
            try {
                ((ServletContextListener)this.get(listener)).contextDestroyed(event);
                continue;
            }
            catch (Throwable t) {
                UndertowServletLogger.REQUEST_LOGGER.errorInvokingListener("contextDestroyed", listener.getListenerInfo().getListenerClass(), t);
            }
        }
    }

    public void servletContextAttributeAdded(String name, Object value) {
        if (!this.started) {
            return;
        }
        ServletContextAttributeEvent sre = new ServletContextAttributeEvent(this.servletContext, name, value);
        for (int i = 0; i < this.servletContextAttributeListeners.length; ++i) {
            ((ServletContextAttributeListener)this.get(this.servletContextAttributeListeners[i])).attributeAdded(sre);
        }
    }

    public void servletContextAttributeRemoved(String name, Object value) {
        if (!this.started) {
            return;
        }
        ServletContextAttributeEvent sre = new ServletContextAttributeEvent(this.servletContext, name, value);
        for (int i = 0; i < this.servletContextAttributeListeners.length; ++i) {
            ((ServletContextAttributeListener)this.get(this.servletContextAttributeListeners[i])).attributeRemoved(sre);
        }
    }

    public void servletContextAttributeReplaced(String name, Object value) {
        if (!this.started) {
            return;
        }
        ServletContextAttributeEvent sre = new ServletContextAttributeEvent(this.servletContext, name, value);
        for (int i = 0; i < this.servletContextAttributeListeners.length; ++i) {
            ((ServletContextAttributeListener)this.get(this.servletContextAttributeListeners[i])).attributeReplaced(sre);
        }
    }

    public void requestInitialized(ServletRequest request) {
        if (!this.started) {
            return;
        }
        if (this.servletRequestListeners.length > 0) {
            int i;
            ServletRequestEvent sre = new ServletRequestEvent(this.servletContext, request);
            try {
                for (i = 0; i < this.servletRequestListeners.length; ++i) {
                    ((ServletRequestListener)this.get(this.servletRequestListeners[i])).requestInitialized(sre);
                }
            }
            catch (RuntimeException e) {
                UndertowServletLogger.REQUEST_LOGGER.errorInvokingListener("requestInitialized", this.servletRequestListeners[i].getListenerInfo().getListenerClass(), e);
                while (i >= 0) {
                    try {
                        ((ServletRequestListener)this.get(this.servletRequestListeners[i])).requestDestroyed(sre);
                    }
                    catch (Throwable t) {
                        UndertowServletLogger.REQUEST_LOGGER.errorInvokingListener("requestDestroyed", this.servletRequestListeners[i].getListenerInfo().getListenerClass(), e);
                    }
                    --i;
                }
                throw e;
            }
        }
    }

    public void requestDestroyed(ServletRequest request) {
        if (!this.started) {
            return;
        }
        if (this.servletRequestListeners.length > 0) {
            ServletRequestEvent sre = new ServletRequestEvent(this.servletContext, request);
            for (int i = this.servletRequestListeners.length - 1; i >= 0; --i) {
                ManagedListener listener = this.servletRequestListeners[i];
                try {
                    ((ServletRequestListener)this.get(listener)).requestDestroyed(sre);
                    continue;
                }
                catch (Exception e) {
                    UndertowServletLogger.REQUEST_LOGGER.errorInvokingListener("requestDestroyed", listener.getListenerInfo().getListenerClass(), e);
                }
            }
        }
    }

    public void servletRequestAttributeAdded(HttpServletRequest request, String name, Object value) {
        if (!this.started) {
            return;
        }
        ServletRequestAttributeEvent sre = new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)request, name, value);
        for (int i = 0; i < this.servletRequestAttributeListeners.length; ++i) {
            ((ServletRequestAttributeListener)this.get(this.servletRequestAttributeListeners[i])).attributeAdded(sre);
        }
    }

    public void servletRequestAttributeRemoved(HttpServletRequest request, String name, Object value) {
        if (!this.started) {
            return;
        }
        ServletRequestAttributeEvent sre = new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)request, name, value);
        for (int i = 0; i < this.servletRequestAttributeListeners.length; ++i) {
            ((ServletRequestAttributeListener)this.get(this.servletRequestAttributeListeners[i])).attributeRemoved(sre);
        }
    }

    public void servletRequestAttributeReplaced(HttpServletRequest request, String name, Object value) {
        if (!this.started) {
            return;
        }
        ServletRequestAttributeEvent sre = new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)request, name, value);
        for (int i = 0; i < this.servletRequestAttributeListeners.length; ++i) {
            ((ServletRequestAttributeListener)this.get(this.servletRequestAttributeListeners[i])).attributeReplaced(sre);
        }
    }

    public void sessionCreated(HttpSession session) {
        if (!this.started) {
            return;
        }
        HttpSessionEvent sre = new HttpSessionEvent(session);
        for (int i = 0; i < this.httpSessionListeners.length; ++i) {
            ((HttpSessionListener)this.get(this.httpSessionListeners[i])).sessionCreated(sre);
        }
    }

    public void sessionDestroyed(HttpSession session) {
        if (!this.started) {
            return;
        }
        HttpSessionEvent sre = new HttpSessionEvent(session);
        for (int i = this.httpSessionListeners.length - 1; i >= 0; --i) {
            ManagedListener listener = this.httpSessionListeners[i];
            ((HttpSessionListener)this.get(listener)).sessionDestroyed(sre);
        }
    }

    public void httpSessionAttributeAdded(HttpSession session, String name, Object value) {
        if (!this.started) {
            return;
        }
        HttpSessionBindingEvent sre = new HttpSessionBindingEvent(session, name, value);
        for (int i = 0; i < this.httpSessionAttributeListeners.length; ++i) {
            ((HttpSessionAttributeListener)this.get(this.httpSessionAttributeListeners[i])).attributeAdded(sre);
        }
    }

    public void httpSessionAttributeRemoved(HttpSession session, String name, Object value) {
        if (!this.started) {
            return;
        }
        HttpSessionBindingEvent sre = new HttpSessionBindingEvent(session, name, value);
        for (int i = 0; i < this.httpSessionAttributeListeners.length; ++i) {
            ((HttpSessionAttributeListener)this.get(this.httpSessionAttributeListeners[i])).attributeRemoved(sre);
        }
    }

    public void httpSessionAttributeReplaced(HttpSession session, String name, Object value) {
        if (!this.started) {
            return;
        }
        HttpSessionBindingEvent sre = new HttpSessionBindingEvent(session, name, value);
        for (int i = 0; i < this.httpSessionAttributeListeners.length; ++i) {
            ((HttpSessionAttributeListener)this.get(this.httpSessionAttributeListeners[i])).attributeReplaced(sre);
        }
    }

    public void httpSessionIdChanged(HttpSession session, String oldSessionId) {
        if (!this.started) {
            return;
        }
        HttpSessionEvent sre = new HttpSessionEvent(session);
        for (int i = 0; i < this.httpSessionIdListeners.length; ++i) {
            ((HttpSessionIdListener)this.get(this.httpSessionIdListeners[i])).sessionIdChanged(sre, oldSessionId);
        }
    }

    private <T> T get(ManagedListener listener) {
        return (T)listener.instance();
    }

    public static ListenerState listenerState() {
        return IN_PROGRAMATIC_SC_LISTENER_INVOCATION.get();
    }

    public static boolean isListenerClass(Class<?> clazz) {
        for (Class c : LISTENER_CLASSES) {
            if (!c.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static enum ListenerState {
        NO_LISTENER,
        DECLARED_LISTENER,
        PROGRAMATIC_LISTENER;

    }
}

