/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.util;

import cn.smallbun.screw.core.util.CollectionUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MappingUtils
implements Serializable {
    public static <TSource, TDestination> TDestination mapping(TSource source, TDestination destination) {
        if (!Objects.isNull(source)) {
            Method[] srcMethods = source.getClass().getMethods();
            Method[] destMethods = destination.getClass().getMethods();
            for (Method m : srcMethods) {
                String srcMethodName = m.getName();
                if (!srcMethodName.startsWith("get")) continue;
                try {
                    Object getValue = m.invoke(source, new Object[0]);
                    for (Method dm : destMethods) {
                        String destMethodName = dm.getName();
                        if (!destMethodName.startsWith("set") || !destMethodName.substring(3).equals(srcMethodName.substring(3))) continue;
                        dm.invoke(destination, getValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return destination;
        }
        return null;
    }

    public static <S, T> List<T> listMapping(List<S> src, Class<T> targetClass) {
        ArrayList<T> target = new ArrayList<T>();
        if (!CollectionUtils.isEmpty(src)) {
            for (S s : src) {
                try {
                    T object = targetClass.newInstance();
                    target.add(object);
                    MappingUtils.mapping(s, object);
                }
                catch (Exception exception) {}
            }
            return target;
        }
        return null;
    }
}

