/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.phoenix;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.phoenix.model.PhoenixColumnModel;
import cn.smallbun.screw.core.query.phoenix.model.PhoenixPrimaryKeyModel;
import cn.smallbun.screw.core.query.phoenix.model.PhoenixSqlDatabaseModel;
import cn.smallbun.screw.core.query.phoenix.model.PhoenixlTableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class PhoenixDataBaseQuery
extends AbstractDatabaseQuery {
    public PhoenixDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws QueryException {
        PhoenixSqlDatabaseModel model = new PhoenixSqlDatabaseModel();
        model.setDatabase(this.getCatalog());
        return model;
    }

    public List<PhoenixlTableModel> getTables() throws QueryException {
        List<PhoenixlTableModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables("", this.getSchema(), "%", new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, PhoenixlTableModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    public List<PhoenixColumnModel> getTableColumns(String table) throws QueryException {
        List<PhoenixColumnModel> list;
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns("", this.getSchema(), table, "%");
            List<PhoenixColumnModel> list2 = Mapping.convertList(resultSet, PhoenixColumnModel.class);
            list2.forEach(model -> model.setColumnType(model.getTypeName()));
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    public List<PhoenixColumnModel> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    public List<PhoenixPrimaryKeyModel> getPrimaryKeys(String table) throws QueryException {
        List<PhoenixPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys("", this.getSchema(), table);
            list = Mapping.convertList(resultSet, PhoenixPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List<PhoenixPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT '' AS TABLE_CAT, TABLE_SCHEM AS TABLE_SCHEM, TABLE_NAME, COLUMN_NAME AS COLUMN_NAME, KEY_SEQ, PK_NAME FROM SYSTEM.\"CATALOG\" WHERE PK_NAME IS NOT NULL AND KEY_SEQ IS NOT NULL GROUP BY TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, KEY_SEQ, PK_NAME";
            resultSet = this.prepareStatement(sql).executeQuery();
            list = Mapping.convertList(resultSet, PhoenixPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    @Override
    protected String getCatalog() throws QueryException {
        return "phoenix";
    }
}

