/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.process;

import cn.smallbun.screw.core.Configuration;
import cn.smallbun.screw.core.engine.EngineFileType;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.metadata.Table;
import cn.smallbun.screw.core.metadata.model.ColumnModel;
import cn.smallbun.screw.core.metadata.model.DataModel;
import cn.smallbun.screw.core.metadata.model.TableModel;
import cn.smallbun.screw.core.process.Process;
import cn.smallbun.screw.core.process.ProcessConfig;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.BeanUtils;
import cn.smallbun.screw.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcess
implements Process {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    volatile Map<String, List<? extends Table>> tablesCaching = new ConcurrentHashMap<String, List<? extends Table>>();
    volatile Map<String, List<Column>> columnsCaching = new ConcurrentHashMap<String, List<Column>>();
    volatile Map<String, List<PrimaryKey>> primaryKeysCaching = new ConcurrentHashMap<String, List<PrimaryKey>>();
    protected Configuration config;

    private AbstractProcess() {
    }

    protected AbstractProcess(Configuration configuration) {
        Assert.notNull(configuration, "Configuration can not be empty!", new Object[0]);
        this.config = configuration;
    }

    protected List<TableModel> filterTables(List<TableModel> tables) {
        ProcessConfig produceConfig = this.config.getProduceConfig();
        if (!Objects.isNull(this.config) && !Objects.isNull(this.config.getProduceConfig())) {
            if (CollectionUtils.isNotEmpty(produceConfig.getDesignatedTableName()) || CollectionUtils.isNotEmpty(produceConfig.getDesignatedTablePrefix()) || CollectionUtils.isNotEmpty(produceConfig.getDesignatedTableSuffix())) {
                return this.handleDesignated(tables);
            }
            return this.handleIgnore(tables);
        }
        return tables;
    }

    private List<TableModel> handleDesignated(List<TableModel> tables) {
        ArrayList<TableModel> tableModels = new ArrayList<TableModel>();
        ProcessConfig produceConfig = this.config.getProduceConfig();
        if (!Objects.isNull(this.config) && !Objects.isNull(produceConfig)) {
            List<String> list;
            if (CollectionUtils.isNotEmpty(produceConfig.getDesignatedTableName())) {
                list = produceConfig.getDesignatedTableName();
                for (String name : list) {
                    tableModels.addAll(tables.stream().filter(j -> j.getTableName().equals(name)).collect(Collectors.toList()));
                }
            }
            if (CollectionUtils.isNotEmpty(produceConfig.getDesignatedTablePrefix())) {
                list = produceConfig.getDesignatedTablePrefix();
                for (String prefix : list) {
                    tableModels.addAll(tables.stream().filter(j -> j.getTableName().startsWith(prefix)).collect(Collectors.toList()));
                }
            }
            if (CollectionUtils.isNotEmpty(produceConfig.getDesignatedTableSuffix())) {
                list = produceConfig.getDesignatedTableSuffix();
                for (String suffix : list) {
                    tableModels.addAll(tables.stream().filter(j -> j.getTableName().endsWith(suffix)).collect(Collectors.toList()));
                }
            }
            return tableModels;
        }
        return tableModels;
    }

    private List<TableModel> handleIgnore(List<TableModel> tables) {
        ProcessConfig produceConfig = this.config.getProduceConfig();
        if (!Objects.isNull(this.config) && !Objects.isNull(produceConfig)) {
            List<String> list;
            if (CollectionUtils.isNotEmpty(produceConfig.getIgnoreTableName())) {
                list = produceConfig.getIgnoreTableName();
                for (String name : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().equals(name)).collect(Collectors.toList());
                }
            }
            if (CollectionUtils.isNotEmpty(produceConfig.getIgnoreTablePrefix())) {
                list = produceConfig.getIgnoreTablePrefix();
                for (String prefix : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().startsWith(prefix)).collect(Collectors.toList());
                }
            }
            if (CollectionUtils.isNotEmpty(produceConfig.getIgnoreTableSuffix())) {
                list = produceConfig.getIgnoreTableSuffix();
                for (String suffix : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().endsWith(suffix)).collect(Collectors.toList());
                }
            }
            return tables;
        }
        return tables;
    }

    public void optimizeData(DataModel dataModel) {
        BeanUtils.beanAttributeValueTrim(dataModel);
        List<TableModel> tables = dataModel.getTables();
        tables.forEach(i -> {
            BeanUtils.beanAttributeValueTrim(i);
            List<ColumnModel> columns = i.getColumns();
            columns.forEach(BeanUtils::beanAttributeValueTrim);
        });
        if (this.config.getEngineConfig().getFileType().equals(EngineFileType.WORD)) {
            BeanUtils.beanAttributeValueEscapeXml(dataModel);
            tables.forEach(i -> {
                BeanUtils.beanAttributeValueEscapeXml(i);
                List<ColumnModel> columns = i.getColumns();
                columns.forEach(BeanUtils::beanAttributeValueEscapeXml);
            });
        }
        if (this.config.getEngineConfig().getFileType().equals(EngineFileType.MD)) {
            BeanUtils.beanAttributeValueReplaceBlank(dataModel);
            tables.forEach(i -> {
                BeanUtils.beanAttributeValueReplaceBlank(i);
                List<ColumnModel> columns = i.getColumns();
                columns.forEach(BeanUtils::beanAttributeValueReplaceBlank);
            });
        }
    }
}

