/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.reflection;

import io.smallrye.graphql.api.Subscription;
import io.smallrye.graphql.client.core.OperationType;
import io.smallrye.graphql.client.impl.typesafe.reflection.NamedElement;
import io.smallrye.graphql.client.impl.typesafe.reflection.ParameterInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import io.smallrye.graphql.client.model.MethodKey;
import io.smallrye.graphql.client.typesafe.api.Multiple;
import jakarta.enterprise.inject.Stereotype;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.microprofile.graphql.Mutation;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.Query;

public class MethodInvocation
implements NamedElement {
    private final TypeInfo type;
    private final Method method;
    private final Object[] parameterValues;
    private List<ParameterInfo> parameters;

    public static MethodInvocation of(Method method, Object ... args) {
        return new MethodInvocation(new TypeInfo(null, method.getDeclaringClass()), method, args);
    }

    private MethodInvocation(TypeInfo type, Method method, Object[] parameterValues) {
        this.type = type;
        this.method = method;
        this.parameterValues = parameterValues;
    }

    public String toString() {
        return this.type + "#" + this.method.getName();
    }

    public String getKey() {
        return this.method.toGenericString();
    }

    public MethodKey getMethodKey() {
        return new MethodKey(this.method.getReturnType(), this.method.getName(), (Class[])this.method.getParameterTypes());
    }

    public OperationType getOperationType() {
        if (this.method.isAnnotationPresent(Mutation.class)) {
            return OperationType.MUTATION;
        }
        if (this.method.isAnnotationPresent(Subscription.class)) {
            return OperationType.SUBSCRIPTION;
        }
        return OperationType.QUERY;
    }

    @Override
    public String getName() {
        return this.queryName().orElseGet(() -> this.mutationName().orElseGet(() -> this.subscriptionName().orElseGet(this::getRawName)));
    }

    private Optional<String> queryName() {
        Query query = this.method.getAnnotation(Query.class);
        if (query != null && !query.value().isEmpty()) {
            return Optional.of(query.value());
        }
        Name name = this.method.getAnnotation(Name.class);
        if (name != null) {
            return Optional.of(name.value());
        }
        return Optional.empty();
    }

    private Optional<String> mutationName() {
        Mutation mutation = this.method.getAnnotation(Mutation.class);
        if (mutation != null && !mutation.value().isEmpty()) {
            return Optional.of(mutation.value());
        }
        return Optional.empty();
    }

    private Optional<String> subscriptionName() {
        Subscription annotation = this.method.getAnnotation(Subscription.class);
        if (annotation != null && !annotation.value().isEmpty()) {
            return Optional.of(annotation.value());
        }
        return Optional.empty();
    }

    @Override
    public String getRawName() {
        String name = this.method.getName();
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    public TypeInfo getReturnType() {
        return new TypeInfo(this.type, this.method.getGenericReturnType(), this.method.getAnnotatedReturnType());
    }

    public boolean hasValueParameters() {
        return this.valueParameters().findAny().isPresent();
    }

    public boolean hasRootParameters() {
        return this.rootParameters().findAny().isPresent();
    }

    public Stream<ParameterInfo> headerParameters() {
        return this.parameters().filter(ParameterInfo::isHeaderParameter);
    }

    public Stream<ParameterInfo> valueParameters() {
        return this.parameters().filter(ParameterInfo::isValueParameter);
    }

    public Stream<ParameterInfo> rootParameters() {
        return this.parameters().filter(ParameterInfo::isRootParameter);
    }

    public List<ParameterInfo> nestedParameters(String path) {
        return this.parameters().filter(ParameterInfo::isNestedParameter).filter(parameterInfo -> parameterInfo.getNestedParameterNames().anyMatch(path::equals)).collect(Collectors.toList());
    }

    private Stream<ParameterInfo> parameters() {
        if (this.parameters == null) {
            this.parameters = IntStream.range(0, this.method.getParameterCount()).mapToObj(i -> new ParameterInfo(this, this.method.getParameters()[i], this.parameterValues[i], this.method.getGenericParameterTypes()[i])).collect(Collectors.toList());
        }
        return this.parameters.stream();
    }

    public TypeInfo getDeclaringType() {
        return this.type;
    }

    public <A extends Annotation> Stream<A> getResolvedAnnotations(Class<?> declaring, Class<A> type) {
        return Stream.concat(this.resolveInheritedAnnotations(declaring, type), MethodInvocation.resolveAnnotations(this.method, type)).filter(Objects::nonNull);
    }

    private <A extends Annotation> Stream<A> resolveInheritedAnnotations(Class<?> declaring, Class<A> type) {
        Stream stream = Stream.empty();
        for (Class<?> i : declaring.getInterfaces()) {
            stream = Stream.concat(stream, this.resolveInheritedAnnotations(i, type));
        }
        stream = Stream.concat(stream, MethodInvocation.resolveAnnotations(declaring, type));
        return stream;
    }

    private static <A extends Annotation> Stream<A> resolveAnnotations(AnnotatedElement annotatedElement, Class<A> type) {
        return Stream.concat(Stream.of(annotatedElement.getAnnotationsByType(type)), MethodInvocation.resolveStereotypes(annotatedElement.getAnnotations(), type));
    }

    private static <A extends Annotation> Stream<A> resolveStereotypes(Annotation[] annotations, Class<A> type) {
        return Stream.of(annotations).map(Annotation::annotationType).filter(annotation -> annotation.isAnnotationPresent(Stereotype.class)).flatMap(a -> MethodInvocation.resolveAnnotations(a, type));
    }

    public Object invoke(Object instance) {
        try {
            if (System.getSecurityManager() == null) {
                this.method.setAccessible(true);
            } else {
                AccessController.doPrivileged(() -> {
                    this.method.setAccessible(true);
                    return null;
                });
            }
            return this.method.invoke(instance, this.parameterValues);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException("can't invoke " + this, e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("expected to be unreachable", e);
        }
    }

    public boolean isStatic() {
        return this.is(Modifier::isStatic);
    }

    public boolean isPublic() {
        return this.is(Modifier::isPublic);
    }

    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public boolean isProtected() {
        return this.is(Modifier::isProtected);
    }

    public boolean isPrivate() {
        return this.is(Modifier::isPrivate);
    }

    private boolean is(Function<Integer, Boolean> f) {
        return f.apply(this.method.getModifiers());
    }

    public boolean isAccessibleFrom(TypeInfo caller) {
        return this.isPublic() || this.isPackagePrivate() && this.type.getPackage().equals(caller.getPackage()) || (this.isPrivate() || this.isProtected()) && caller.isNestedIn(this.getDeclaringType());
    }

    public boolean isSingle() {
        return !this.method.getReturnType().isAnnotationPresent(Multiple.class);
    }

    public boolean isDeclaredInObject() {
        return this.method.getDeclaringClass().equals(Object.class);
    }

    public boolean isDeclaredInCloseable() {
        return this.method.getDeclaringClass().equals(Closeable.class) || this.method.getDeclaringClass().equals(AutoCloseable.class);
    }

    public String getOperationTypeAsString() {
        switch (this.getOperationType()) {
            case MUTATION: {
                return "mutation";
            }
            case SUBSCRIPTION: {
                return "subscription ";
            }
        }
        return "query";
    }
}

