/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx;

import io.vertx.core.Handler;
import java.util.function.Function;

public class DelegatingHandler<U, V>
implements Handler<U> {
    private final Handler<V> handler;
    private final Function<U, V> mapper;

    public DelegatingHandler(Handler<V> handler, Function<U, V> mapper) {
        this.handler = handler;
        this.mapper = mapper;
    }

    public void handle(U event) {
        this.handler.handle(this.mapper.apply(event));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingHandler that = (DelegatingHandler)o;
        return this.handler.equals(that.handler);
    }

    public int hashCode() {
        return this.handler.hashCode();
    }
}

