/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.operators;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ProcessorBase<I, O>
implements Flow.Processor<I, O>,
Flow.Subscription {
    private Flow.Subscriber<? super O> downstream;
    private Flow.Subscription upstreamSubscription;
    private final AtomicBoolean cancelled = new AtomicBoolean();

    ProcessorBase() {
    }

    protected boolean cancelled() {
        return this.cancelled.get();
    }

    protected Flow.Subscription upstreamSubscription() {
        return this.upstreamSubscription;
    }

    protected Flow.Subscriber<? super O> downstream() {
        return this.downstream;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super O> subscriber) {
        this.downstream = subscriber;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.upstreamSubscription = subscription;
        this.downstream.onSubscribe(this);
    }

    @Override
    public void onError(Throwable throwable) {
        if (!this.cancelled()) {
            this.cancel();
            this.downstream.onError(throwable);
        }
    }

    @Override
    public void onComplete() {
        if (!this.cancelled()) {
            this.downstream.onComplete();
        }
    }

    @Override
    public void request(long n) {
        if (!this.cancelled()) {
            this.upstreamSubscription.request(n);
        }
    }

    @Override
    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            this.upstreamSubscription.cancel();
            this.upstreamSubscription = null;
        }
    }
}

