/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.common.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String[] NO_STRINGS = new String[0];
    private static final Pattern ITEM_PATTERN = Pattern.compile("(,+)|([^\\\\,]+)|\\\\(.)");

    private StringUtil() {
    }

    public static String[] split(String text) {
        if (text == null || text.isEmpty()) {
            return NO_STRINGS;
        }
        Matcher matcher = ITEM_PATTERN.matcher(text);
        String item = null;
        StringBuilder b = null;
        ArrayList<String> list = new ArrayList<String>(4);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                if (item == null) continue;
                list.add(item);
                item = null;
                continue;
            }
            if (matcher.group(2) != null) {
                assert (item == null) : "Regular expression matching malfunctioned";
                item = matcher.group(2);
                continue;
            }
            if (matcher.group(3) != null) {
                if (b == null) {
                    b = new StringBuilder();
                }
                if (item != null) {
                    b.append(item);
                    item = null;
                }
                b.append(matcher.group(3));
                while (matcher.find() && matcher.group(1) == null) {
                    if (matcher.group(2) != null) {
                        b.append(matcher.group(2));
                        continue;
                    }
                    if (matcher.group(3) != null) {
                        b.append(matcher.group(3));
                        continue;
                    }
                    throw new IllegalStateException();
                }
                list.add(b.toString());
                b.setLength(0);
                continue;
            }
            throw new IllegalStateException();
        }
        if (item != null) {
            list.add(item);
        }
        return list.toArray(NO_STRINGS);
    }

    private static boolean isAsciiLetterOrDigit(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private static boolean isAsciiUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static char toAsciiLowerCase(char c) {
        return StringUtil.isAsciiUpperCase(c) ? (char)(c + 32) : c;
    }

    public static boolean equalsIgnoreCaseReplacingNonAlphanumericByUnderscores(String envProperty, CharSequence dottedProperty) {
        int length = dottedProperty.length();
        if (envProperty.length() != dottedProperty.length()) {
            if (length == 0 || envProperty.length() != dottedProperty.length() + 1) {
                return false;
            }
            if (dottedProperty.charAt(length - 1) == '\"' && envProperty.charAt(length - 1) == '_' && envProperty.charAt(length) == '_') {
                length = dottedProperty.length() - 1;
            } else {
                return false;
            }
        }
        for (int i = 0; i < length; ++i) {
            char pCh;
            char ch = dottedProperty.charAt(i);
            if (!(!StringUtil.isAsciiLetterOrDigit(ch) ? envProperty.charAt(i) != '_' : ((pCh = envProperty.charAt(i)) < '\u0080' ? StringUtil.toAsciiLowerCase(pCh) != StringUtil.toAsciiLowerCase(ch) : Character.toLowerCase(envProperty.charAt(i)) != Character.toLowerCase(ch)))) continue;
            return false;
        }
        return true;
    }

    public static String replaceNonAlphanumericByUnderscores(String name) {
        return StringUtil.replaceNonAlphanumericByUnderscores(name, new StringBuilder(name.length()));
    }

    public static String replaceNonAlphanumericByUnderscores(String name, StringBuilder sb) {
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (StringUtil.isAsciiLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
            if (c != '\"' || i + 1 != length) continue;
            sb.append('_');
        }
        return sb.toString();
    }

    public static String toLowerCaseAndDotted(String name) {
        int length = name.length();
        if (length == 0) {
            return name;
        }
        if (length > 1 && name.charAt(length - 1) == '_' && name.charAt(length - 2) == '_') {
            --length;
        }
        byte[] result = new byte[length];
        int i = 0;
        if (name.charAt(0) == '_') {
            result[0] = 37;
            ++i;
        }
        boolean quotesOpen = false;
        while (i < length) {
            char c = name.charAt(i);
            if ('_' == c) {
                int next = i + 1;
                if (quotesOpen) {
                    if (next == length) {
                        result[i] = 34;
                    } else if (name.charAt(next) == '_') {
                        result[i] = 34;
                        result[next] = 46;
                        ++i;
                        quotesOpen = false;
                    } else {
                        result[i] = 46;
                    }
                } else if (next < length) {
                    char d = name.charAt(next);
                    if (Character.isDigit(d)) {
                        result[next] = (byte)d;
                        for (int j = next + 1; j < length; ++j) {
                            d = name.charAt(j);
                            if (!Character.isDigit(d)) {
                                if ('_' == d) {
                                    result[i] = 91;
                                    result[j] = 93;
                                    i = j;
                                } else {
                                    result[i] = 46;
                                    i = j;
                                }
                                break;
                            }
                            result[j] = (byte)d;
                        }
                    } else if (name.charAt(next) == '_') {
                        result[i] = 46;
                        result[next] = 34;
                        ++i;
                        quotesOpen = true;
                    } else {
                        result[i] = 46;
                    }
                } else {
                    result[i] = 46;
                }
            } else {
                result[i] = (byte)Character.toLowerCase(c);
            }
            ++i;
        }
        return new String(result, 0, 0, result.length);
    }

    public static boolean isNumeric(CharSequence digits) {
        return StringUtil.isNumeric(digits, 0, digits.length());
    }

    public static boolean isNumeric(CharSequence digits, int start, int end) {
        if (digits.length() == 0) {
            return false;
        }
        for (int i = start; i < end; ++i) {
            if (Character.isDigit(digits.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String skewer(String camelHumps) {
        return StringUtil.skewer(camelHumps, '-');
    }

    public static String skewer(String camelHumps, char separator) {
        return StringUtil.skewer(camelHumps, 0, camelHumps.length(), new StringBuilder(), separator);
    }

    private static String skewer(String camelHumps, int start, int end, StringBuilder b, char separator) {
        if (camelHumps.isEmpty()) {
            throw new IllegalArgumentException("Method seems to have an empty name");
        }
        int cp = camelHumps.codePointAt(start);
        b.appendCodePoint(Character.toLowerCase(cp));
        if ((start += Character.charCount(cp)) == end) {
            return b.toString();
        }
        if (Character.isUpperCase(cp)) {
            int nextCp = camelHumps.codePointAt(start);
            if (Character.isUpperCase(nextCp)) {
                do {
                    b.appendCodePoint(Character.toLowerCase(nextCp));
                    cp = nextCp;
                    if ((start += Character.charCount(cp)) != end) continue;
                    return b.toString();
                } while (!Character.isLowerCase(nextCp = camelHumps.codePointAt(start)));
                b.append(separator);
                return StringUtil.skewer(camelHumps, start, end, b, separator);
            }
            b.appendCodePoint(nextCp);
            start += Character.charCount(nextCp);
            while (true) {
                if (start == end) {
                    return b.toString();
                }
                cp = camelHumps.codePointAt(start);
                if (Character.isUpperCase(cp)) {
                    b.append(separator);
                    return StringUtil.skewer(camelHumps, start, end, b, separator);
                }
                b.appendCodePoint(cp);
                start += Character.charCount(cp);
            }
        }
        do {
            if (Character.isUpperCase(cp = camelHumps.codePointAt(start))) {
                b.append(separator);
                return StringUtil.skewer(camelHumps, start, end, b, separator);
            }
            b.appendCodePoint(cp);
        } while ((start += Character.charCount(cp)) != end);
        return b.toString();
    }
}

