/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.ddl.create;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.lexer.token.Token;
import io.shardingjdbc.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingjdbc.core.parsing.parser.exception.SQLParsingException;
import io.shardingjdbc.core.parsing.parser.sql.SQLParser;
import io.shardingjdbc.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingjdbc.core.parsing.parser.token.IndexToken;
import io.shardingjdbc.core.rule.ShardingRule;

public abstract class AbstractCreateParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public AbstractCreateParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public DDLStatement parse() {
        this.lexerEngine.nextToken();
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateIndexAndKeyword());
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateAndKeyword());
        DDLStatement result = new DDLStatement();
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX)) {
            this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateIndexAndIndexName());
            this.parseIndex(result);
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateTableAndTableName());
        } else {
            throw new SQLParsingException("Can't support other CREATE grammar unless CREATE TABLE, CREATE INDEX.", new Object[0]);
        }
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        return result;
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateIndexAndKeyword();

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateAndKeyword();

    protected Keyword[] getSkippedKeywordsBetweenCreateIndexAndIndexName() {
        return new Keyword[0];
    }

    private void parseIndex(DDLStatement ddlStatement) {
        Token currentToken = this.lexerEngine.getCurrentToken();
        int beginPosition = currentToken.getEndPosition() - currentToken.getLiterals().length();
        String literals = currentToken.getLiterals();
        this.lexerEngine.skipUntil(DefaultKeyword.ON);
        this.lexerEngine.nextToken();
        String tableName = this.lexerEngine.getCurrentToken().getLiterals();
        ddlStatement.getSqlTokens().add(new IndexToken(beginPosition, literals, tableName));
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateTableAndTableName();

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected TableReferencesClauseParser getTableReferencesClauseParser() {
        return this.tableReferencesClauseParser;
    }
}

