/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.Sentry;
import io.sentry.spring.jakarta.webflux.AbstractSentryWebFilter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@ApiStatus.Experimental
public class SentryWebFilter
extends AbstractSentryWebFilter {
    public SentryWebFilter(@NotNull IHub hub) {
        super(hub);
    }

    public Mono<Void> filter(@NotNull ServerWebExchange serverWebExchange, @NotNull WebFilterChain webFilterChain) {
        @NotNull IHub requestHub = Sentry.cloneMainHub();
        ServerHttpRequest request = serverWebExchange.getRequest();
        @Nullable ITransaction transaction = this.maybeStartTransaction(requestHub, request);
        return webFilterChain.filter(serverWebExchange).doFinally(__ -> this.doFinally(serverWebExchange, requestHub, transaction)).doOnError(e -> this.doOnError(transaction, (Throwable)e)).doFirst(() -> {
            Sentry.setCurrentHub((IHub)requestHub);
            this.doFirst(serverWebExchange, requestHub);
        });
    }
}

