/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.autoconfigure;

import io.sentry.config.provider.ConfigurationProvider;
import io.sentry.spring.autoconfigure.SentryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootConfigurationProvider
implements ConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(SpringBootConfigurationProvider.class);
    private final SentryProperties sentryProperties;

    public SpringBootConfigurationProvider(SentryProperties sentryProperties) {
        this.sentryProperties = sentryProperties;
    }

    public String getProperty(String key) {
        switch (key) {
            case "compression": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getCompression());
            }
            case "maxmessagelength": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getMaxMessageLength());
            }
            case "timeout": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getTimeout());
            }
            case "sample.rate": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getSampleRate());
            }
            case "uncaught.handler.enabled": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getUncaughtHandlerEnabled());
            }
            case "stacktrace.hidecommon": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getStacktrace().getHideCommon());
            }
            case "stacktrace.app.packages": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getStacktrace().getAppPackages());
            }
            case "buffer.dir": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getBuffer().getDir());
            }
            case "buffer.size": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getBuffer().getSize());
            }
            case "buffer.flushtime": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getBuffer().getFlushTime());
            }
            case "buffer.shutdowntimeout": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getBuffer().getShutdownTimeout());
            }
            case "buffer.gracefulshutdown": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getBuffer().getGracefulShutdown());
            }
            case "async": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getAsync().getEnabled());
            }
            case "async.shutdowntimeout": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getAsync().getShutdownTimeout());
            }
            case "async.gracefulshutdown": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getAsync().getGracefulShutdown());
            }
            case "async.queuesize": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getAsync().getQueueSize());
            }
            case "async.threads": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getAsync().getThreads());
            }
            case "async.priority": {
                return this.logAndReturnIfSet(key, this.sentryProperties.getAsync().getPriority());
            }
        }
        logger.debug("Unsupported option: {}", (Object)key);
        return null;
    }

    private String logAndReturnIfSet(String key, Object value) {
        if (value == null) {
            return null;
        }
        String ret = value.toString();
        logger.debug("Found {}={} in Spring Boot config.", (Object)key, (Object)ret);
        return ret;
    }
}

